package portablesimulator.gui.themes;

import java.awt.Font;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;
import portablesimulator.csv.Repository;

public class ThemeManager {

    public static final int THEME_SEA = 0;
    public static final int THEME_FOREST = 1;
    public static final int THEME_WINE = 2;
    public static final int THEME_STONE = 3;
    public static final int THEME_OS_DEFAULT = 4;
    public static final int THEME_JAVA_DEFAULT = 5;
    public static final int THEME_GTK_DEFAULT = 6;

    public static void setMetalTheme(final int type) {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        try {
            if (type == THEME_OS_DEFAULT) {
                String className = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(className);
                Repository.getConfig().themeLabelColorful = false;
            } else if (type == THEME_JAVA_DEFAULT) {
                for (LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if ("Metal".equalsIgnoreCase(info.getName())) {
                        MetalTheme theme = new OceanTheme();
                        MetalLookAndFeel.setCurrentTheme(theme);
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                Repository.getConfig().themeLabelColorful = false;
            } else if (type == THEME_GTK_DEFAULT) {
                for (LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if ("Nimbus".equalsIgnoreCase(info.getName())) {
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                Repository.getConfig().themeLabelColorful = false;
            } else {
                for (LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if ("Metal".equalsIgnoreCase(info.getName())) {// CDE/Motif  |  Nimbus  | Metal
                        MetalTheme theme = null;
                        Repository.getConfig().themeLabelColorful = true;
                        switch (type) {
                            case THEME_FOREST:
                                theme = new MetalForestTheme();
                                break;
                            case THEME_WINE:
                                theme = new MetalWineTheme();
                                break;
                            case THEME_SEA:
                                theme = new MetalSeaTheme();
                                break;
                            case THEME_STONE:
                                theme = new MetalStoneTheme();
                                break;
                        }
                        MetalLookAndFeel.setCurrentTheme(theme);
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
            }
        } catch (Exception e) {
            // If Nimbus is not available, you can set the GUI to another look and feel.
        }
    }

    public static void setFont(String name, int style, int size) {
        for (java.util.Map.Entry<?, ?> entry : UIManager.getDefaults().entrySet()) {
            if (entry.getKey().toString().toLowerCase().endsWith("font")) {
                Font f2 = new Font(name, style, size);
                FontUIResource f1 = new FontUIResource(f2);
                UIManager.put(entry.getKey(), f1);
            }
        }
    }

    public static void updateUITree() {
        Window[] win = Window.getWindows();
        for (int i = 0; i < win.length; ++i) {
            SwingUtilities.updateComponentTreeUI(win[i]);
            if (win[i] instanceof JDialog) {
                win[i].pack();
            }
        }
    }
}
