package portablesimulator.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import portablesimulator.PSItem;
import portablesimulator.PSWrap;
import portablesimulator.PSItemType;
import portablesimulator.csv.Repository;

public class MyCheckBoxForCheckTool extends JCheckBoxEx {
    public final PSWrap wrap;
    public final PSFrame frame;
    private static Timer timer = new Timer(true);
    private TimerTask task = null;
    private TimerTask task2 = null;
    private JPopupMenu menu = null;
    private ActionListener al = null;
    private JMenuItem menuItemSelectOnly;
    private JMenuItem menuItemSelectExclude;
    private JMenuItem menuItemSelectSame;
    private JMenuItem menuItemSelectAll;
    private JMenuItem menuItemCancel;

    public void updateViewCount() {
        PSItem item = wrap.item;
        int count = item.viewCount;
        if (item.itemType == PSItemType.TYPE_CHARM) {
            setText(item.name + item.skills.skillToString(null, true) + "[" + item.slotCount + "] = " + count);
        }else {
            setText(item.name + "[" + item.slotCount + "] = " + count);
        }
    }

    public MyCheckBoxForCheckTool(final PSFrame frame, final PSWrap wrap) {
        this.frame = frame;
        this.wrap = wrap;
        this.task = null;

        updateViewCount();
        setSelected(Repository.getConfig().lastSession.items.isViewChecked(wrap.item));
        addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 1) {
                    if (me.getButton() != MouseEvent.BUTTON1) {
                        showPopupMenu(me.getX(), me.getY());
                    }else if ((me.getModifiers() & MouseEvent.CTRL_MASK) != 0) {
                        showPopupMenu(me.getX(), me.getY());
                    }
                }
            }

            public void mousePressed(final MouseEvent me) {
                schedulePopup(me.getX(), me.getY());
            }

            public void mouseReleased(MouseEvent me) {
                cancelPopup();
            }

            public void mouseExited(MouseEvent me) {
                cancelPopup();
            }
        });
        al = new ActionListener() {

            public void actionPerformed(ActionEvent ae) {
                menuActionPerformed(ae);
            }
        };
        addActionListener(al);
    }

    public void showPopupMenu(final int x, final int y) {
        PSItem item = wrap.item;

        this.menu = new JPopupMenu();

        menuItemSelectOnly = new JMenuItem(item.getArmorName() + "̂");
        menuItemSelectOnly.addActionListener(al);
        menu.add(menuItemSelectOnly);

        menuItemSelectExclude = new JMenuItem(item.getArmorName() + "ȊO");
        menuItemSelectExclude.addActionListener(al);
        menu.add(menuItemSelectExclude);

        menuItemSelectSame = new JMenuItem(item.formatPartsName() + "S");
        menuItemSelectSame.addActionListener(al);
        menu.add(menuItemSelectSame);

        menuItemSelectAll = new JMenuItem("Sʂ̑S");
        menuItemSelectAll.addActionListener(al);
        menu.add(menuItemSelectAll);

        menuItemCancel = new JMenuItem("LZ");
        menu.add(menuItemCancel);

        SwingUtilities.invokeLater(new Runnable(){
            public void run() {
                menu.show(MyCheckBoxForCheckTool.this, x, y);
            }
        });
    }

    public void menuActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this) {
            frame.doPrintTextArea(wrap.item.getFormatted() + wrap.getAdditionalInfo(), "ACeڍ");
        } else if (ae.getSource() == this.menuItemSelectOnly) {
            for (MyCheckBoxForCheckTool box : frame.getChecktoolList()) {
                if (box.wrap.item.itemType == wrap.item.itemType) {
                    box.setSelected(box.wrap.item == wrap.item);
                }
            }
        } else if (ae.getSource() == this.menuItemSelectExclude) {
            for (MyCheckBoxForCheckTool box : frame.getChecktoolList()) {
                if (box.wrap.item.itemType == wrap.item.itemType) {
                    box.setSelected(box.wrap.item != wrap.item);
                }
            }
        } else if (ae.getSource() == this.menuItemSelectAll) {
            for (MyCheckBoxForCheckTool box : frame.getChecktoolList()) {
                box.setSelected(true);
            }
        } else if (ae.getSource() == this.menuItemSelectSame) {
            for (MyCheckBoxForCheckTool box : frame.getChecktoolList()) {
                if (box.wrap.item.itemType == wrap.item.itemType) {
                    box.setSelected(true);
                }
            }
        }
        scheduleRepaint();
    }

    public void scheduleRepaint() {
        synchronized(timer) {
            if (task2 != null) {
                task2.cancel();
            }
            task2 = new TimerTask() {
                @Override
                public void run() {
                    synchronized(timer) {
                        task2 = null;
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                frame.doRepaintResultList();
                            }
                        });
                    }
                }
            };
            timer.schedule(task2, 1500);
        }
    }


    public void schedulePopup(final int x, final int y) {
        task = new TimerTask() {
            @Override
            public void run() {
                synchronized (timer) {
                    task = null;
                    showPopupMenu(x, y);
                }
            }
        };
        timer.schedule(task, 1000);
    }

    public void cancelPopup() {
        synchronized (timer) {
            if (task != null) {
                task.cancel();
                task = null;
            }
        }
    }
}
