package portablesimulator.decoration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import portablesimulator.IProgress;
import portablesimulator.PSArmorSet;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.PSSearchItems;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillPoint;
import portablesimulator.skillset.SkillSet;

public class PlusOneFinder {

    public PlusOneFinder(PSSession session, SkillSet skills, PSSearchItems items) {
        this.session = session;
        this.searchSkill = skills;
        this.listSearchSkills = Repository.getFukugo().searchFilter(session, skills);
        this.items = items;
        this.matcherCache = new TreeMap<SkillSet, DecorationMatcher>();
        this.matchedResult = new TreeMap<SkillSet, Set<PSArmorSet>>();
        this.seekList = new ArrayList<SkillPoint>();
        this.baseScanned = new TreeMap<PSArmorSet, Boolean>();

        List<SkillPoint> listSkills = Repository.getSkillCategories().listPoints();
        for (SkillPoint p : listSkills) {
            if (p.skillPoint > 0) {
                seekList.add(p);
            }
        }
        for (int i = 0; i < skills.size(); ++i) {
            if (skills.positive(i) == false) {
                for (SkillPoint p : listSkills) {
                    if (p.skillPoint < 0) {
                        seekList.add(p);
                    }
                }
                break;
            }
        }
    }

    public void addToResult(PSArmorSet set, SkillSet skills) {
        Set<PSArmorSet> pool = matchedResult.get(skills);
        if (onlySkillScan) {
            if (pool != NOTHING) {
                matchedResult.put(skills, NOTHING);
            }
            return;
        }
        if (pool == null) {
            pool = new TreeSet<PSArmorSet>();
            matchedResult.put(skills, pool);
        }
        pool.add(set);
    }

    public Set<SkillSet> quickFindPlusSkills(PSArmorSet set, SkillSet searchSkills, List<DecorationSlot> prevResult) {
        SkillSet searchMasked = searchSkills.getNamedSkillSetForDisplay();
        Set<SkillSet> ret = new TreeSet<SkillSet>();

        for (DecorationSlot slot : prevResult) {
            SkillSet skills = new SkillSet();
            set.calculateUseList(skills, false);
            skills.sum_all(slot.getFullDecorationSkills());
            skills = skills.getNamedSkillSetForDisplay();

            for (int i = 0; i < skills.size(); ++i) {
                SkillKind kind = skills.kind(i);
                int point1 = skills.point(i);
                int point2 = searchMasked.pointOfKind(kind);
                if (point1 != point2) {
                    ret.add(skills);
                }
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        boolean existToPositive = false;
        for (int i = 0; i < searchSkills.size(); ++i) {
            int p = searchSkills.point(i);
            if (p < 0 && searchSkills.positive(i) == true && p % 5 != 0) {
                existToPositive = true;
            }
        }
        if (existToPositive) {
            Set<SkillSet> tempSet = new TreeSet<SkillSet>();
            for (SkillSet skill2 : ret) {
                SkillSet skill3 = new SkillSet();
                skill3.set_all(skill2);
                for (int i = 0; i < searchSkills.size(); ++i) {
                    int p = searchSkills.point(i);
                    if (p < 0 && searchSkills.positive(i) == true && p % 5 != 0) {
                        if (skill3.indexOfKind(searchSkills.kind(i)) < 0) {
                            skill3.set(searchSkills.kind(i), p, true);
                        }
                    }
                }
                tempSet.add(skill3);
            }
            ret = tempSet;
        }
        return ret;
    }

    private DecorationMatcher getMatcher(SkillSet skills) {
        DecorationMatcher matcher = matcherCache.get(skills);

        if (matcher == null) {
            PSSession search2 = session.makeCopy();
            matcher = new DecorationMatcher(search2, skills, items);
            matcherCache.put(skills, matcher);
            if (useNestedFind) {
                if (matcherCache.size() >= 500) {
                    matcherCache.clear();
                }
            }
        }

        return matcher;
    }

    private PSArmorSet findPlusOne(PSArmorSet set, SkillSet skills, List<DecorationSlot> result, boolean isBase) {
        DecorationMatcher matcher = getMatcher(skills);

        boolean check = false;

        List<DecorationSlot> tempList = new ArrayList<DecorationSlot>();
        if (matcher.canHaveEnoughDecoration(set, true, tempList)) {
            if (result != null) {
                result.addAll(tempList);
            }

            Set<SkillSet> plusSet = quickFindPlusSkills(set, skills, tempList);

            if (plusSet == null) {
                addToResult(set, skills);
            } else {
                for (SkillSet skill2 : plusSet) {
                    addToResult(set, skill2);
                }
            }
            return set;
        }else if (check) {
        }

        return null;
    }

    public boolean findAnyPlusOne(PSArmorSet set, List<DecorationSlot> result, long timeout, List<DecorationSlot> prevResult, IProgress progress) {
        boolean match = false;
        wasTimeout = false;
        long startTick = System.currentTimeMillis();

        Boolean x = baseScanned.get(set);
        if (x != null) {
            return x;
        }

        ArrayList<SkillSet> queue = new ArrayList<SkillSet>();
        HashSet<SkillSet> passed0 = new HashSet<SkillSet>();
        HashSet<SkillSet> already = new HashSet<SkillSet>();

        queue.addAll(listSearchSkills);

        while (queue.isEmpty() == false) {
            if (progress != null && progress.isCanceled()) {
                break;
            }
            if (timeout > 0) {
                if (System.currentTimeMillis() >= startTick + timeout) {
                    wasTimeout = true;
                    break;
                }
            }
            SkillSet baseSkill = queue.remove(queue.size() - 1);
            if (passed0.contains(baseSkill)) {
                continue;
            }
            passed0.add(baseSkill);

            DecorationMatcher matcher = getMatcher(baseSkill);

            if (prevResult == null) {
                List<DecorationSlot> tempList = new ArrayList<DecorationSlot>();
                if (matcher.canHaveEnoughDecoration(set, true, tempList)) {
                    prevResult = tempList;
                } else {
                    if (onlySkillScan) {
                        continue;
                    }
                    //baseScanned.put(set, Boolean.FALSE);
                    continue;
                }
            }

            Set<SkillSet> quick = quickFindPlusSkills(set, baseSkill, prevResult);
            if (quick != null) {
                for (SkillSet skill2 : quick) {
                    addToResult(set, skill2);
                    if (!onlySkillScan || !useNestedFind) {
                        queue.add(skill2);
                    }
                    match = true;
                }
            } else {
                if (!DecorationMatcher.existMoreSlot(prevResult)) {
                    if (onlySkillScan) {
                        continue;
                    }
                    continue;
                }
            }

            for (SkillPoint seek : seekList) {
                int sx = baseSkill.indexOfKind(seek.skillKind);
                if (sx >= 0) {
                    if (baseSkill.positive(sx)) {
                        if (baseSkill.point(sx) >= seek.skillPoint) {
                            continue;
                        }
                    } else {
                        if (baseSkill.point(sx) <= seek.skillPoint) {
                            continue;
                        }
                    }
                }
                SkillSet skills = new SkillSet();
                skills.set_all(baseSkill);
                skills.set(seek.skillKind, seek.skillPoint, seek.positiveRange);
                if (already.contains(skills)) {
                    continue;
                }
                already.add(skills);
                if (onlySkillScan) {
                    if (matchedResult.containsKey(skills)) {
                        continue;
                    }
                }
                if (findPlusOne(set, skills, result, false) != null) {
                    match = true;
                    if (onlySkillScan) {
                        continue;
                    } else if (useNestedFind) {
                        queue.add(skills);
                    } else {
                        break;
                    }
                }
            }
        }

        //baseScanned.put(set, match ? Boolean.TRUE : Boolean.FALSE);
        /*
         if (onlySkillScan) {
                    return false;
                }
        */
        return match;
    }

    public void tryFixMinus(List<PSArmorSet> listArmorSet, List<DecorationSlot> slotList) {
        TreeSet<SkillSet> needRetest = new TreeSet<SkillSet>();

        for (SkillSet test : matchedResult.keySet()) {
            for (int i = 0; i < test.size(); ++i) {
                if (test.point(i) < 0 && test.positive(i) == false) {
                    SkillSet newTest = new SkillSet();
                    newTest.set_all(test);
                    newTest.set(test.kind(i), test.point(i) + 1, true);
                    needRetest.add(newTest);
                }
            }
        }

        List<PSArmorSet> scan = new ArrayList<PSArmorSet>();
        for (PSArmorSet set : listArmorSet) {
            if (baseScanned.containsKey(set)) {
                scan.add(set);
            }
        }

        for (SkillSet test : needRetest) {
            for (PSArmorSet set : scan) {
                findPlusOne(set, test, slotList, false);
            }
        }
    }

    public Map<SkillSet, Set<PSArmorSet>> getResultMap(List<PSArmorSet> listArmorSet) {
        Map<SkillSet, Set<PSArmorSet>> result = new TreeMap<SkillSet, Set<PSArmorSet>>();

        Set<PSArmorSet> scan = new TreeSet<PSArmorSet>();
        if (listArmorSet == null) {
            scan.addAll(baseScanned.keySet());
        }else {
            for (PSArmorSet set : listArmorSet) {
                if (baseScanned.containsKey(set)) {
                    scan.add(set);
                }
            }
        }
        for (SkillSet skills : matchedResult.keySet()) {
            Set<PSArmorSet> listHit = matchedResult.get(skills);
            Set<PSArmorSet> listFound = result.get(skills);

            if (listHit == NOTHING) {
                result.put(skills, NOTHING);
            }else {
                Set<PSArmorSet> set1;
                Set<PSArmorSet> set2;

                if (listHit.size() > scan.size()) {
                    set1 = listHit;
                    set2 = scan;
                } else {
                    set1 = scan;
                    set2 = listHit;
                }
                for (PSArmorSet set : set2) {
                    if (set1.contains(set)) {
                        if (listFound == null) {
                            listFound = new TreeSet<PSArmorSet>();
                            result.put(skills, listFound);
                        }
                        listFound.add(set);
                    }
                }
            }
        }
        result.remove(searchSkill);

        return result;
    }

    public String getResultAsText(List<PSArmorSet> listArmorSet, boolean longFormat) {
        Map<SkillSet, Set<PSArmorSet>> map = getResultMap(listArmorSet);
        StringBuilder str = new StringBuilder();
        boolean firstElement = true;
        if (longFormat) {
            str.append(getResultAsText(listArmorSet, false));
            str.append("\n");
        }
        str.append(map.size() + " Types Found:");
        str.append("[");
        
        for (SkillSet skill : map.keySet()) {
            if (longFormat) {
                str.append("\n");
            } else {
                if (firstElement) {
                    firstElement = false;
                } else {
                    str.append(", ");
                }
            }

            String skillName = getShortFormat(skill);
            int count = map.get(skill).size();

            if (onlySkillScan) {
                str.append(skillName);
            } else {
                str.append(skillName);
                if (longFormat) {
                    for (PSArmorSet set : map.get(skill)) {
                        str.append("\n");
                        str.append(" -");
                        str.append(set);
                    }
                } else {
                    str.append("(");
                    str.append(count);
                    str.append(")");
                }
            }
        }
        if (longFormat) {
            str.append("\n");
        }
        str.append("]");
        return str.toString();
    }

    public String getShortFormat(SkillSet skills) {
        SkillSet newSet = new SkillSet();
        SkillSet base = this.searchSkill;
        for (int i = 0; i < skills.size(); ++i) {
            SkillKind kind = skills.kind(i);
            int point1 = skills.point(i);
            int point2 = base.pointOfKind(kind);
            if (point1 != point2) {
                newSet.set(kind, point1, point1 > 0 ? true : false);
            }
        }
        return newSet.getNamedSkillNameForSearch().toString();
    }

    public void trashGarbage() {
        if (onlySkillScan) {
            for (SkillSet skill : matchedResult.keySet()) {
                matchedResult.put(skill, NOTHING);
            }
            baseScanned.clear();
        }
    }
    private final PSSession session;
    private final SkillSet searchSkill;
    private final TreeSet<SkillSet> listSearchSkills;
    private final PSSearchItems items;
    private final Map<SkillSet, DecorationMatcher> matcherCache;
    private final Map<SkillSet, Set<PSArmorSet>> matchedResult;
    private final TreeMap<PSArmorSet, Boolean> baseScanned;
    private final List<SkillPoint> seekList;
    public static final TreeSet<PSArmorSet> CONFLICT = new TreeSet<PSArmorSet>();
    public static final TreeSet<PSArmorSet> NOTHING = new TreeSet<PSArmorSet>();
    public boolean useNestedFind = false;
    public boolean wasTimeout = false;
    public boolean onlySkillScan = false;
    public boolean debug = false;
}
