package portablesimulator;

import java.util.ArrayList;
import portablesimulator.skillset.SkillSet;
import java.util.TreeMap;

public class PSWrap implements Comparable {
    public PSWrap(PSItem item) {
        this.item = item;
    }

    public PSItem item;
    public ArrayList<PSWrap> virtualList = null;
    public SkillSet maskedSkills = null;
    public ArrayList<PSWrap> sameArmors = null;
    public ArrayList<PSWrap> childArmors = new ArrayList<PSWrap>();
    public ArrayList<PSWrap> charmGroup = null;
    public ArrayList<PSWrap> charmGroupSeek = null;

    public int hashCode() {
        return item.name.hashCode();
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        PSWrap t = (PSWrap)o;
        return item.compareTo(t.item);
    }

    public String getAdditionalInfo() {
        if (item.itemType == PSItemType.TYPE_CHARM && charmGroup != null) {
            StringBuilder str = new StringBuilder();
            String LF = "\n";
            str.append("/ʂ{" + charmGroup.size() + " pattern " + LF);
            for (PSWrap charm : charmGroup) {
                str.append("@" + charm.item.toString() + LF);
            }
            str.append("}" + LF);
            return str.toString();
        }
        if (item.isVirtual && virtualList != null) {
            StringBuilder str = new StringBuilder();
            String LF = "\n";
            str.append("h{").append(LF);
            for (int i = 0; i < virtualList.size(); ++ i) {
                str.append(virtualList.get(i).item).append(LF);
            }
            str.append("}");
            return str.toString();
        }
        return "";
    }

    public String toString() {
        return item.name + "[" + item.slotCount + "]" + this.maskedSkills;
    }

    private static TreeMap<PSItem, PSWrap> mapVirtual = new TreeMap<PSItem, PSWrap>();

    public static PSWrap getVirtualWrap(int itemType, int slotCount) {
        PSItem item = PSItem.getVirtualItem(itemType, slotCount);
        PSWrap wrap = mapVirtual.get(item);
        if (wrap == null) {
            wrap = new PSWrap(item);
            mapVirtual.put(item, wrap);
        }
        return wrap;
    }
}
