typedef unsigned char UCHAR;

#include <guigui01.h>

#define MAXSIZ	8 * 1024 * 1024 + 310

void put32(UCHAR *p, int i)
{
	p[0] =  i        & 0xff;
	p[1] = (i >>  8) & 0xff;
	p[2] = (i >> 16) & 0xff;
	p[3] = (i >> 24) & 0xff;
	return;
}

#define CMDLIN_FLG_H	0
#define	CMDLIN_IN		1
#define	CMDLIN_OUT		2
#define CMDLIN_LABEL	3

static unsigned char cmdusg[] = {
	0x86, 0x51,
		0x11, '-', 'h', 0x20,
		0x88, 0x8c,
		0x04, 'l', 'a', 'b', 'e', 'l', 0x31, 0x01,
	0x40
};

void G01Main()
{
	UCHAR *buf, l[12];
	int i, j, k;
	static UCHAR head[0x8c] = {
		0x4c, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, /* +08(d) : g = h + 0x8c */
		0x00, 0x00, 0x00, 0x00, 0x2e, 0x74, 0x65, 0x78,
		0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x20, 0x00, 0x10, 0x60, 0x2e, 0x64, 0x61, 0x74,
		0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +4c(d) h = dataZNVTCY */
		0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +54(d) g */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x40, 0x00, 0x40, 0xc0, 0x2e, 0x62, 0x73, 0x73, /* align=8 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x80, 0x00, 0x10, 0xc0
	};
	static UCHAR foot[0xa6] = {
		0x2e, 0x66, 0x69, 0x6c, 0x65, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x00, 0x00,
		0x67, 0x01, 0x6b, 0x5f, 0x62, 0x69, 0x6e, 0x2e,
		0x6f, 0x62, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x2e, 0x74, 0x65, 0x78,
		0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x01, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x2e, 0x64, 0x61, 0x74, 0x61, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
		0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +5a(d) h */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x2e, 0x62, 0x73, 0x73,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x03, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +90(q) l 8܂ */
		0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
		0x02, 0x00, 0x04, 0x00, 0x00, 0x00
	};

	g01_setcmdlin(cmdusg);
	buf = jg01_malloc(MAXSIZ);
	g01_getcmdlin_str_s0(CMDLIN_LABEL, 12, l);
	j = g01_getcmdlin_flag_o(CMDLIN_FLG_H) << 2;

	g01_getcmdlin_fopen_s_0_4(CMDLIN_IN);
	i = jg01_fread1f_4(MAXSIZ - 310, buf + 0x8c + j);
	if (j) {
		put32(&buf[0x8c], i);
		i += 4;
	}
	for (k = 0; k < 0x8c; k++)
		buf[k] = head[k];
	for (k = 0; k < 0xa6; k++)
		buf[0x8c + i + k] = foot[k];
	k = i + 0x8c;
	put32(&buf[0x08], k);
	put32(&buf[0x4c], i);
	put32(&buf[0x54], k);
	put32(&buf[0x8c + 0x5a + i], i);

	k = 0;
	if (*l == '\0')
		g01_putstr0_exit1("label error.");
	for (;;) {
		buf[0x8c + 0x90 + i + k] = l[k];
		k++;
		if (l[k] == '\0')
			break;
		if (k == 8)
			g01_putstr0_exit1("label too long.");
	}

	g01_getcmdlin_fopen_s_3_5(CMDLIN_OUT);
	jg01_fwrite1f_5(i + 306, buf);
	return;
}
