﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;

namespace OP_Guren_Ragan
{
    class StatusControler
    {
        private OripachiState oriState;
        private TimeStatus timeStatus;
        private BgmControler bgmControler;
        private RollControler[] rollControler = new RollControler[3];
        private double oldTime;
        private ArrayList stopNumbers;
        private float rollingTime = 3;
        private float leftStopTime = 0.5f;
        private float rightStopTime = 0.5f;
        private float middleStopTime = 0.5f;
        private float throughTime = 3.0f;

        public OripachiState OriState
        {
            set { oriState = value; }
            get { return oriState; }
        }

        public TimeStatus TimeStatus
        {
            set { timeStatus = value; }
            get { return timeStatus; }
        }

        public StatusControler(RollControler[] rc, BgmControler bgmCon)
        {
            this.rollControler = rc;
            oriState = OripachiState.Roll;
            timeStatus = TimeStatus.Stop;
            this.bgmControler = bgmCon;
        }

        public void UpdateStatus(GameTime gameTime)
        {
            double nowTime = gameTime.TotalGameTime.TotalSeconds;
            switch (timeStatus)
            {
                case TimeStatus.Start:
                    BallStack.Instance.SetBingoArray(2);
                    BallStack bs = BallStack.Instance;
                    stopNumbers = bs.GetStopNumber();
                    timeStatus = TimeStatus.LeftStart;
                    oldTime = gameTime.TotalGameTime.TotalSeconds;
                    break;

                case TimeStatus.Stop:
                    oldTime = gameTime.TotalGameTime.TotalSeconds;
                    if (rollControler[1].state == RollState.Stop3 && oriState == OripachiState.Roll)
                    {
                        bgmControler.StopInstance.Volume = 0.2f;
                        bgmControler.StopInstance.Play();
                        if(bgmControler.BgmInstance2.State==SoundState.Playing){
                            bgmControler.BgmInstance2.Stop();
                            rollControler[0].reachAlpa((int)stopNumbers[0], 255);
                            rollControler[2].reachAlpa((int)stopNumbers[1], 255);
                        }
                    }
                    break;

                case TimeStatus.LeftStart:
                    rollControler[0].StartRoll();
                    timeStatus = TimeStatus.MiddleStart;
                    oldTime = gameTime.TotalGameTime.TotalSeconds;
                    break;

                case TimeStatus.RightStart:
                    if (oldTime + 0.5 < nowTime)
                    {
                        rollControler[2].StartRoll();
                        timeStatus = TimeStatus.Rolling;
                        oldTime = gameTime.TotalGameTime.TotalSeconds;
                    }
                    break;

                case TimeStatus.MiddleStart:
                    if (oldTime + 0.5 < nowTime)
                    {
                        rollControler[1].StartRoll();
                        timeStatus = TimeStatus.RightStart;
                        oldTime = gameTime.TotalGameTime.TotalSeconds;

                    }
                    break;

                case TimeStatus.Rolling:
                    if (oldTime + rollingTime < nowTime)
                    {
                        timeStatus = TimeStatus.LeftStop;
                        oldTime = gameTime.TotalGameTime.TotalSeconds;
                    }
                    break;

                case TimeStatus.LeftStop:
                    if (oldTime + leftStopTime < nowTime)
                    {
                        rollControler[0].StopRoll((int)stopNumbers[0]);
                        timeStatus = TimeStatus.RightStop;
                        oldTime = gameTime.TotalGameTime.TotalSeconds;
                        if (BallStack.Instance.ReachFlag)
                        {
                            rightStopTime = 3.0f;
                        }
                        else
                        {
                            rightStopTime = 0.5f;
                        }
                    }
                    break;

                case TimeStatus.RightStop:
                    if (oldTime + rightStopTime < nowTime)
                    {
                        rollControler[2].StopRoll((int)stopNumbers[1]);
                        oldTime = gameTime.TotalGameTime.TotalSeconds;
                        if (BallStack.Instance.ReachFlag)
                        {
                            timeStatus = TimeStatus.Reach;
                            throughTime = 5.0f;
                            middleStopTime = 5.0f;
                        }
                        else
                        {
                            timeStatus = TimeStatus.MiddleStop;
                            middleStopTime = 0.5f;
                        }
                    }
                    break;

                case TimeStatus.MiddleStop:
                    if (oldTime + middleStopTime < nowTime)
                    {
                        rollControler[1].StopRoll((int)stopNumbers[2]);
                        TimeStatus = TimeStatus.Stop;
                        oldTime = gameTime.TotalGameTime.TotalSeconds;
                    }
                    break;

                case TimeStatus.Reach:
                    if (rollControler[2].state == RollState.Stop3)
                    {
                        bgmControler.BgmInstance.Stop();

                        bgmControler.ReachInstance.Volume = 1.0f;
                        bgmControler.ReachInstance.Play();
                        rollControler[0].reachAlpa((int)stopNumbers[0], 30);
                        rollControler[2].reachAlpa((int)stopNumbers[1], 30);
                        TimeStatus = TimeStatus.ThroughtStart;
                    }
                    break;

                case TimeStatus.ThroughtStart:
                    if (oldTime + throughTime < nowTime)
                    {
                        rollControler[1].ThroughRoll((int)stopNumbers[2]);
                        oldTime = gameTime.TotalGameTime.TotalSeconds;
                        TimeStatus = TimeStatus.Throughting;
                    }
                    else
                    {
                        if(bgmControler.ReachInstance.State == SoundState.Stopped){
                            bgmControler.BgmInstance2.Volume = 0.1f;
                            bgmControler.BgmInstance2.Play();
                        }
                    }
                    break;

                case TimeStatus.Throughting:
                    if (oldTime + 5.0f < nowTime)
                    {
                        oriState = OripachiState.Whiteout;
                        timeStatus = TimeStatus.MiddleStop;
                        oldTime = gameTime.TotalGameTime.TotalSeconds;

                    }
                    break;

                default:
                    break;
            }
        }

    }
}
