﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace OP_Guren_Ragan
{
    class RollControler
    {
        private Texture2D[] zugaraTexture = new Texture2D[9];
        private Vector2[] pos1 = new Vector2[9];
        private Vector2[] pos2 = new Vector2[9];
        private int rollBackCount=0;
        private int rollUpCount = 0;
        private float posX;
        private int stopNumber=0;
        private byte[] alpaArray = new byte[9];
        
        public RollState state = RollState.None;

        float speedBuff=0;

        public Vector2[] Pos1
        {
            get{return pos1;}
            set{pos1=value;}
        }

        public Vector2[] Pos2
        {
            get { return pos2; }
            set { pos2 = value; }
        }

        public float PosX
        {
            get { return posX; }
            set { posX = value; }
        }

        public RollControler(Texture2D[] texture, float posX) {
            for (int i = 0; i < 9; i++)
            {
                alpaArray[i] = 255;
            }
            zugaraTexture = texture;
            this.posX = posX;
            SetPosi(pos1,posX,150);
            SetPosi(pos2, posX, 1950);
        }

        public void SetPosi(Vector2[] pos, float startX, float startY)
        {
            pos[0].Y = startY;
            pos[0].X = startX;
            for (int i = 1; i < pos.Length; i++)
            {
                pos[i].X = startX;
                pos[i].Y = startY - i * 200;
            }
        }

        public void Move(float speed, byte alpa)
        {
            for(int i=0;i<9;i++){
                alpaArray[i] = alpa;
            }
            if (pos1[pos1.Length - 1].Y >= 800)
            {
                SetPosi(pos1, posX, pos2[pos2.Length - 1].Y - 200);
            }
            else
            {
                SetPosi(pos1, posX, pos1[0].Y + speed);
            }

            if (pos2[pos2.Length - 1].Y >= 800)
            {
                SetPosi(pos2, posX, pos1[pos1.Length - 1].Y - 200);
            }
            else
            {
                SetPosi(pos2, posX, pos2[0].Y + speed);
            }
        }

        public bool RollBack()
        {
            int max = 30;
            rollBackCount++;
            for (int i = 0; i < pos1.Length; i++)
            {
                if(rollBackCount > 0 && rollBackCount<=max/2){
                    pos1[i].Y -= 1;
                    pos2[i].Y -= 1;
                }
                else if (rollBackCount > max/2 && rollBackCount <= max)
                {
                    pos1[i].Y += 1;
                    pos2[i].Y += 1;
                }
            }
            if (rollBackCount == max)
            {
                rollBackCount = 0;
                return false;
            }
            return true;
        }

        public void RollUp()
        {
            int max = 30;
            rollUpCount++;
            for (int i = 0; i < pos1.Length; i++)
            {
                if (rollUpCount > 0 && rollUpCount <= max / 2)
                {
                    pos1[i].Y += 1;
                    pos2[i].Y += 1;
                }
                else if (rollUpCount > max / 2 && rollUpCount <= max)
                {
                    pos1[i].Y -= 1;
                    pos2[i].Y -= 1;
                }
            }
            if (rollUpCount == max)
            {
                rollUpCount = 0;
                state = RollState.None;
            }
        }

        public void RollDraw(SpriteBatch spriteBatch)
        {
            for (int i = 0; i < zugaraTexture.Length;i++ )
            {
                spriteBatch.Draw(zugaraTexture[i], pos1[i], new Color(255, 255, 255, alpaArray[i]));
                spriteBatch.Draw(zugaraTexture[i], pos2[i], new Color(255, 255, 255, alpaArray[i]));
            
            }
        }

        public void RollDrawR(SpriteBatch spriteBatch)
        {
            for (int i = 0; i < zugaraTexture.Length; i++)
            {
                spriteBatch.Draw(zugaraTexture[i], pos1[8 - i], new Color(255, 255, 255, alpaArray[8-i]));
                spriteBatch.Draw(zugaraTexture[i], pos2[8 - i], new Color(255, 255, 255, alpaArray[8-i]));
            
            }
        }

        public void Roll()
        {
            float startY = 0;
            switch(state){
                //以下図柄スタート・等加速度運動時処理
                case RollState.Start1:
                    if (RollBack() == false)
                    {
                        state = RollState.Start2;
                    }
                    break;

                case RollState.Start2:
                    
                    speedBuff+=2;
                    if(speedBuff<=50){
                        Move(speedBuff, 255);
                    }else{
                        Move(50,20);
                    }
                    break;

                //以下図柄停止時の処理
                case RollState.Stop1:
                    speedBuff = 0;
                    startY = 150 + (stopNumber - 1) * 200 - 800;
                    SetPosi(Pos2, PosX, startY);
                    SetPosi(Pos1, PosX, 1800 + startY); ;
                    state = RollState.Stop2;
                    break;

                case RollState.Stop2:
                    if (pos2[0].Y <= (150 + (stopNumber - 1) * 200) - 600)
                    {
                        Move(10f, 255);
                    }
                    else
                    {
                        Move(5f, 255);
                    }

                    if (pos2[0].Y >= (150 + (stopNumber - 1) * 200))
                    {
                        state = RollState.Stop3;
                    }
                    break;

                case RollState.Stop3:
                    RollUp();
                    break;

                //以下、図柄スルー時処理
                case RollState.Through1:
                    speedBuff = 0;
                    startY = 150 + (stopNumber - 1) * 200 - 800;
                    SetPosi(Pos2, PosX, startY);
                    SetPosi(Pos1, PosX, 1800 + startY);
                    state = RollState.Through2;

                    break;

                case RollState.Through2:
                    if (pos2[0].Y <= (150 + (stopNumber - 1) * 200) - 600)
                    {
                        Move(10f, 255);
                    }
                    else
                    {
                        Move(5f, 255);
                    }

                    if (pos2[0].Y >= (150 + stopNumber * 200))
                    {
                        state = RollState.Start2;
                    }
                    break;

                case RollState.None:
                default:
                    speedBuff = 0;
                    break;
            }
        }

        public void SetAlpa(byte alpa)
        {
            for (int i = 0; i < 9; i++)
            {
                alpaArray[i] = alpa;
            }

        }

        public void reachAlpa(int number,byte alpa)
        {
            for (int i = 0; i < 9; i++)
            {
                alpaArray[i] = alpa;
            }
            alpaArray[number-1] = 255;
        }

        public int StopNumber
        {
            get { return stopNumber; }
            set { stopNumber = value; }
        }

        public void StartRoll()
        {
            state = RollState.Start1;
        }

        public void StopRoll(int number)
        {
            state = RollState.Stop1;
            stopNumber = number;
        }

        public void ThroughRoll(int number)
        {
            state = RollState.Through1;
            stopNumber = number;
        }
    }
}
