using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using System.Threading;

namespace OP_Guren_Ragan
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Texture2D[] zugaraTexture = new Texture2D[9];
        Texture2D backGround;
        Texture2D reachImage;
        Texture2D yline;
        RollControler[] rollControler = new RollControler[3];
        KeyboardState oldState;
        Texture2D white;
        //Texture2D windowFrame;
        int whiteAlpha = 0;
        BgmControler bgmControler;
        MovieControler movieControler;
        StatusControler statusControler;
        public SpriteFont font;        //tHg
        float oldTime;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            graphics.PreferredBackBufferWidth = 640;
            graphics.PreferredBackBufferHeight = 480;
            graphics.PreferMultiSampling = false;
            //graphics.IsFullScreen = true; 

            this.Exiting += new EventHandler(Game1_Exiting);

        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here   


            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);
            

            // TODO: use this.Content to load your game content here
            backGround = Content.Load<Texture2D>("Image\\back");
            white = Content.Load<Texture2D>("Image\\white");
            reachImage = Content.Load<Texture2D>("Image\\reach");
            //windowFrame = Content.Load<Texture2D>("windowFrame2");

            TextureCreationParameters txtpara = new TextureCreationParameters(2048, 2048, 0, 0, SurfaceFormat.Unknown,
                  TextureUsage.None, new Color(0, 0, 0), FilterOptions.None, FilterOptions.None);
            yline = Texture2D.FromFile(graphics.GraphicsDevice, "../../../Content\\Image\\Effect\\yline.bmp", txtpara);


            bgmControler = new BgmControler(Content);
            movieControler = new MovieControler(Content);

            for (int i=1; i <= zugaraTexture.Length ;i++ )
            {
                zugaraTexture[i-1] = Content.Load<Texture2D>("Image\\Zugara\\guren"+i.ToString());
            }
            for (int i = 0; i < rollControler.Length;i++ )
            {
                rollControler[i] = new RollControler(zugaraTexture,i*200+35);
            }

            
            statusControler = new StatusControler(rollControler, bgmControler);

            font = Content.Load<SpriteFont>("Font\\SpriteFont1");

            

         }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed ||
                Keyboard.GetState().IsKeyDown(Keys.Escape)) this.Exit();

            // TODO: Add your update logic here
            for (int i = 0; i < rollControler.Length; i++)
            {
                rollControler[i].Roll();
            }

            
            statusControler.UpdateStatus(gameTime);
            


            KeyboardState newState = Keyboard.GetState();

            // Is the SPACE key down?
            if (newState.IsKeyDown(Keys.F5))
            {
                // If not down last update, key has just been pressed.
                if (!oldState.IsKeyDown(Keys.F5))
                {
                    if (movieControler.Player.State == MediaState.Playing)
                    {
                        movieControler.Player.Stop();
                    }
                }
            }


            // Is the SPACE key down?
            if (newState.IsKeyDown(Keys.Space))
            {
                // If not down last update, key has just been pressed.
                if (!oldState.IsKeyDown(Keys.Space))
                {

                    
                    if (statusControler.TimeStatus == TimeStatus.Stop&&rollControler[1].state==RollState.None)
                    {
                        statusControler.TimeStatus = TimeStatus.Start;
                    }
                    
                    if (bgmControler.BgmInstance.State == SoundState.Stopped)
                    {
                        bgmControler.BgmInstance.Volume = 0.1f;
                        bgmControler.BgmInstance.Play();
                    }

                }
            }
            else if (oldState.IsKeyDown(Keys.Space))
            {
                // Key was down last update, but not down now, so
                // it has just been released.
            }

            oldState = newState;


            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);
            // TODO: Add your drawing code here
            spriteBatch.Begin(SpriteBlendMode.AlphaBlend);
            
            switch (statusControler.OriState)
            {
                case OripachiState.Roll:
                    DrawZugara(gameTime);
                    int sp_no = (int)((gameTime.TotalGameTime.Milliseconds / 100) % 64);
                    spriteBatch.Draw(yline,
                                         new Vector2(0, 0),
                                         new Rectangle(sp_no * 256, 0, 256, 256),
                                         Color.White,
                                         0.0f,
                                         new Vector2(0, 0),
                                         2f,
                                         new SpriteEffects(),
                                         0);
                    break;

                case OripachiState.Premonition:
                    break;

                case OripachiState.Whiteout:
                    DrawZugara(gameTime);

                    whiteAlpha += 5;
                    spriteBatch.Draw(white, new Vector2(0.0f, 0.0f), new Color(255, 255, 255, (byte)(whiteAlpha)));
                    if (whiteAlpha == 255)
                    {
                        whiteAlpha = 0;
                        statusControler.OriState = OripachiState.Reach;
                        movieControler.SelectMovie();
                        movieControler.Play();
                    }
                    break;

                case OripachiState.Reach:
                    if (bgmControler.BgmInstance2.State != SoundState.Stopped)
                    {
                        bgmControler.BgmInstance2.Stop();
                    }
                    Texture2D texture = movieControler.GetTexture();

                    // 擾eNX`gĕ`
                    if (texture != null)
                    {
                        spriteBatch.Draw(texture, new Vector2(0.0f, 0.0f), Color.White);
                        float x = graphics.PreferredBackBufferWidth - zugaraTexture[rollControler[0].StopNumber - 1].Width 
                            + zugaraTexture[rollControler[0].StopNumber - 1].Width*1/4;

                        float y = graphics.PreferredBackBufferHeight - zugaraTexture[rollControler[0].StopNumber - 1].Height 
                            + zugaraTexture[rollControler[0].StopNumber - 1].Height*3/4
                            + (float)(2 * Math.Sin(gameTime.TotalGameTime.TotalMilliseconds / 500));

                        spriteBatch.Draw(zugaraTexture[rollControler[0].StopNumber - 1],
                                         new Vector2(x, y-5), 
                                         null,
                                         new Color(255, 255, 255, 255),
                                         0.0f,
                                         new Vector2(0,0),
                                         1/4f,
                                         new SpriteEffects(),
                                         0);
                        x = graphics.PreferredBackBufferWidth - zugaraTexture[rollControler[0].StopNumber - 1].Width 
                            + zugaraTexture[rollControler[0].StopNumber - 1].Width * 3 / 4;
                        
                        spriteBatch.Draw(zugaraTexture[rollControler[0].StopNumber - 1],
                                         new Vector2(x, y-5),
                                         null,
                                         new Color(255, 255, 255, 255),
                                         0.0f,
                                         new Vector2(0, 0),
                                         1 / 4f,
                                         new SpriteEffects(),
                                         0);
                        x = graphics.PreferredBackBufferWidth - zugaraTexture[rollControler[0].StopNumber - 1].Width
                            + zugaraTexture[rollControler[0].StopNumber - 1].Width * 2 / 4;

                        int number = (int)((gameTime.TotalGameTime.TotalMilliseconds / 20) % 9);
                        spriteBatch.Draw(zugaraTexture[number],
                                         new Vector2(x, y - 5),
                                         null,
                                         new Color(255, 255, 255, 30),
                                         0.0f,
                                         new Vector2(0, 0),
                                         1 / 4f,
                                         new SpriteEffects(),
                                         0);
                    }
                    if (movieControler.Player.State == MediaState.Stopped)
                    {
                        bgmControler.StopInstance.Volume = 1f;
                        bgmControler.StopInstance.Play();
                        statusControler.OriState = OripachiState.Round;
                        oldTime = (float)gameTime.TotalGameTime.TotalSeconds;
                        movieControler.SetRoundMovie();
                        movieControler.Player.Volume = 0.2f;
                        movieControler.Play();
                        rollControler[0].reachAlpa(1, 255);
                        rollControler[2].reachAlpa(1, 255);
                    }
                    break;

                case OripachiState.Round:
                    float newTime = (float)gameTime.TotalGameTime.TotalSeconds;
                    if (oldTime + 3.0f < newTime)
                    {
                        texture = movieControler.GetTexture();
                        
                        // 擾eNX`gĕ`
                        if (texture != null)
                        {
                            spriteBatch.Draw(texture, new Vector2(0.0f, 0.0f), Color.White);
                            float x =graphics.PreferredBackBufferWidth-zugaraTexture[rollControler[0].StopNumber-1].Width;
                            float y =graphics.PreferredBackBufferHeight-zugaraTexture[rollControler[0].StopNumber-1].Height;
                            spriteBatch.Draw(zugaraTexture[rollControler[0].StopNumber-1], new Vector2(x, y), new Color(255, 255, 255, 255));
                        }
                        if (movieControler.Player.State == MediaState.Stopped)
                        {
                            statusControler.OriState = OripachiState.Roll;
                        }
                    }
                    else
                    {
                        DrawZugara(gameTime);
                    }
                    break;

                case OripachiState.None:
                default:
                    break;
            }
            if (rollControler[0].state == RollState.None && rollControler[1].state == RollState.None&&statusControler.OriState==OripachiState.Roll)
            {
                spriteBatch.DrawString(font, "SPASE:START", new Vector2(0, 460), Color.Red);
            }
            spriteBatch.End();
            base.Draw(gameTime);
        }

        void Game1_Exiting(object sender, EventArgs e)
        {
            // Add any code that must execute before the game ends.
            
        }

        void DrawZugara(GameTime gameTime)
        {
            float moveSize = (backGround.Width - graphics.PreferredBackBufferWidth) / 2;
            float x = (float)(-moveSize - (moveSize * Math.Sin(gameTime.TotalGameTime.TotalMilliseconds / 5000)));
            spriteBatch.Draw(backGround, new Vector2(x, 0.0f), new Color(255, 255, 255, 255));
            rollControler[0].RollDraw(spriteBatch);
            rollControler[1].RollDraw(spriteBatch);
            rollControler[2].RollDrawR(spriteBatch);
            //spriteBatch.Draw(windowFrame, new Vector2(0.0f, 0.0f), new Color(255, 255, 255, 255));
            if(bgmControler.ReachInstance.State==SoundState.Playing){
                float reahPosy = 100.0f + 30 * (float)Math.Sin(gameTime.TotalGameTime.TotalMilliseconds / 100);
                //spriteBatch.Draw(reachImage, new Vector2(0, reahPosy), new Color(255, 255, 255, 255));
            }
        }
    }
}
