package jp.bne.deno.ordermaid.view.helper;

import java.util.ArrayList;
import java.util.List;

import jp.bne.deno.ordermaid.dao.SystemTable;

import org.apache.wicket.markup.html.form.DropDownChoice;

import com.google.inject.Inject;

public class SheetsDropDownChoice extends DropDownChoice<Integer> {

	@Inject
	SystemTable table;

	public SheetsDropDownChoice(String id) {
		super(id);
		super.setNullValid(false);
		List<Integer> list = new ArrayList<Integer>();
		int sheetNum = Integer.parseInt(table.getSystemItem("sheetNum", "10")
				.getValue());
		for (int i = 1; i <= sheetNum; i++) {
			list.add(new Integer(i));
		}
		super.setChoices(list);
	}

}
