package jp.bne.deno.ordermaid.view;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import jp.bne.deno.ordermaid.dao.OrderTable;
import jp.bne.deno.ordermaid.model.OrderData;
import jp.bne.deno.ordermaid.model.OrderDetail;
import jp.bne.deno.ordermaid.model.SalesData;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import com.google.inject.Inject;

/**
 * @author hasegawt. 売上月次集計表示画面.
 */
public class SalesSummaryPage extends BasePage {

	@Inject
	OrderTable orderTable;

	String year;

	String month;

	private List<SalesData> list = new ArrayList<SalesData>();

	public SalesSummaryPage() {
		Form<SalesSummaryPage> form = new Form<SalesSummaryPage>("form",
				new CompoundPropertyModel<SalesSummaryPage>(this));
		form.add(new FeedbackPanel("feedback"));
		add(form);

		// 日付ドロップダウン作成
		List<String> years = new ArrayList<String>();
		List<String> months = new ArrayList<String>();
		final Calendar current = Calendar.getInstance();

		int baseYear = current.get(Calendar.YEAR);
		for (int i = baseYear - 2; i < baseYear + 2; i++) {
			years.add(Integer.toString(i));
		}
		year = Integer.toString(baseYear);
		for (int i = 1; i < 13; i++) {
			months.add(Integer.toString(i));
		}
		month = Integer.toString(current.get(Calendar.MONTH) + 1);

		DropDownChoice<String> yearChoice = new DropDownChoice<String>("year",
				years);
		DropDownChoice<String> monthChoice = new DropDownChoice<String>(
				"month", months);
		form.add(yearChoice);
		form.add(monthChoice);

		form.add(new Button("search") {
			public void onSubmit() {
				calc();
			}
		});

		form.add(new ListView<SalesData>("list") {
			@Override
			protected void populateItem(ListItem<SalesData> item) {
				final SalesData data = item.getModelObject();
				item.setModel(new CompoundPropertyModel<SalesData>(data));
				item.add(new Button("select") {
					public void onSubmit() {
						setResponsePage(new SalesDaySummaryPage(year, month,
								Integer.toString(data.getDay())));
					}
				});
				item.add(new Label("day"));
				item.add(new Label("groups"));
				item.add(new Label("count"));
				item.add(new Label("totalPrice"));
				item.add(new Label("unitPrice"));
			}
		});
		calc();
	}

	private void calc() {
		list = new ArrayList<SalesData>();
		Calendar target = Calendar.getInstance();
		Calendar orderDate = Calendar.getInstance();

		target.set(Integer.parseInt(year), Integer.parseInt(month) - 1, 1);
		List<OrderData> orders = orderTable.findOrderByMonth(target.getTime());
		for (int day = 1; day <= target.getActualMaximum(Calendar.DATE); day++) {
			SalesData sales = new SalesData();
			sales.setDay(day);
			int groups = 0;
			int count = 0;
			long totalPrice = 0;
			for (int i = 0; i < orders.size(); i++) {
				OrderData order = orders.get(i);
				orderDate.setTime(order.getOrderDate());
				if (orderDate.get(Calendar.DAY_OF_MONTH) == day) {
					count += order.getDetails().size();
					groups++;
					for (int j = 0; j < order.getDetails().size(); j++) {
						OrderDetail detail = order.getDetails().get(j);
						totalPrice += detail.getSumPrice();
					}
				}
			}
			sales.setGroups(groups);
			sales.setCount(count);
			sales.setTotalPrice(totalPrice);
			list.add(sales);
		}
	}

}
