package jp.bne.deno.ordermaid.model;

import java.io.Serializable;

/**
 * 売上データ集計表示用bean
 * 
 * @author hasegawt
 * 
 */
public class SalesData implements Serializable, Cloneable {

	private static final long serialVersionUID = 1L;

	int count = 0;

	int day = 0;

	int groups = 0;

	int hour = 0;

	long totalPrice = 0;

	public int getCount() {
		return count;
	}

	public int getDay() {
		return day;
	}

	public int getGroups() {
		return groups;
	}

	public int getHour() {
		return hour;
	}

	public long getTotalPrice() {
		return totalPrice;
	}

	public long getUnitPrice() {
		if (count == 0 || totalPrice == 0) {
			return 0;
		} else {
			try {
				return totalPrice / count;
			} catch (ArithmeticException e) {
				e.printStackTrace();
				return 0;
			}
		}
	}

	public void setCount(int count) {
		this.count = count;
	}

	public void setDay(int day) {
		this.day = day;
	}

	public void setGroups(int groups) {
		this.groups = groups;
	}

	public void setHour(int hour) {
		this.hour = hour;
	}

	public void setTotalPrice(long totalPrice) {
		this.totalPrice = totalPrice;
	}

	public void setUnitPrice(int unitPrice) {
		// no effect
	}

}
