package jp.bne.deno.ordermaid.model;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class OrderItem implements Serializable {

	@ManyToOne(fetch = FetchType.EAGER, targetEntity = MenuItem.class, optional = true)
	@JoinColumn(name = "menu_id")
	private MenuItem menuItem;

	public OrderItem() {

	}

	public OrderItem(MenuItem menuItem) {
		this.menuItem = menuItem;
		this.price = menuItem.getPrice().longValue();
	}

	public String toString() {
		return menuItem.getMenuName();
	}

	@Id
	@GeneratedValue
	private long id;

	/**
	 * 受注取消の場合、true
	 */
	private Boolean cancel = Boolean.FALSE;

	/**
	 * @return the cancel
	 */
	public Boolean isCancel() {
		return cancel;
	}

	/**
	 * @param cancel
	 *            the cancel to set
	 */
	public void setCancel(Boolean cancel) {
		this.cancel = cancel;
		this.price = new Long(0);
	}

	/**
	 * @return the price
	 */
	public Long getPrice() {
		if (price == null) {
			return new Long(0);
		} else {
			return price;
		}
	}

	/**
	 * @param price
	 *            the price to set
	 */
	public void setPrice(Long price) {
		this.price = price;
	}

	private Long price;

	/**
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(long id) {
		this.id = id;
	}

	/**
	 * @return the menuItem
	 */
	public MenuItem getMenuItem() {
		return menuItem;
	}

	/**
	 * @param menuItem
	 *            the menuItem to set
	 */
	public void setMenuItem(MenuItem menuItem) {
		this.menuItem = menuItem;
		this.price = menuItem.getPrice().longValue();
	}

	@ManyToOne(targetEntity = OrderDetail.class, optional = true)
	@JoinColumn(name = "detail_id")
	private OrderDetail detail;

	/**
	 * @return the detail
	 */
	public OrderDetail getDetail() {
		return detail;
	}

	/**
	 * @param detail
	 *            the detail to set
	 */
	public void setDetail(OrderDetail detail) {
		this.detail = detail;
	}

	public String getOrderName() {
		if (cancel) {
			return "取消[" + menuItem.getMenuType().getMenuType() + "-"
					+ menuItem.getMenuName() + "]";
		} else {
			return menuItem.getMenuType().getMenuType() + "-"
					+ menuItem.getMenuName();
		}
	}

	public String getShortName() {
		if (cancel) {
			return "";
		} else {
			return menuItem.getShortName();
		}
	}

}
