package jp.bne.deno.ordermaid.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

/**
 * 注文明細
 * 
 * @author hasegawt
 * 
 */
@Entity
public class OrderDetail implements Serializable, Cloneable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue
	private int seq = -1;

	@Column(nullable = false, length = 1)
	private String sex = "O";

	@Column(nullable = false)
	private boolean takeOut = false;

	@Column(nullable = false, length = 3)
	private Integer sheetId = new Integer(1);

	/**
	 * コンストラクタ.
	 * 
	 */
	public OrderDetail() {

	}

	/**
	 * コピーコンストラクタ.
	 * 
	 */
	public OrderDetail(OrderDetail src) {
		this.setItems(src.getItems());
		this.setOrder(src.getOrder());
		this.setSeq(-1);
		this.setSex(src.getSex());
		this.setSheetId(src.getSheetId());
		this.setTakeOut(src.takeOut);
	}

	@ManyToOne(fetch = FetchType.EAGER, cascade = { CascadeType.MERGE })
	@JoinColumn(name = "orderid")
	private OrderData order = new OrderData();

	public OrderData getOrder() {
		return order;
	}

	public void setOrder(OrderData order) {
		this.order = order;
	}

	@OneToMany(mappedBy = "detail", targetEntity = OrderItem.class, cascade = CascadeType.ALL)
	private List<OrderItem> items = new ArrayList<OrderItem>();

	/**
	 * @return the item
	 */
	public List<OrderItem> getItems() {
		return items;
	}

	/**
	 * @param item
	 *            the item to set
	 */
	public void setItems(List<OrderItem> item) {
		this.items = item;
	}

	public int getSeq() {
		return seq;
	}

	public void setSeq(int seq) {
		this.seq = seq;
	}

	public String getSex() {
		return sex;
	}

	public Integer getSheetId() {
		return sheetId;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public void setSheetId(Integer sheetId) {
		this.sheetId = sheetId;
	}

	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		for (OrderItem menu : items) {
			if (menu != null) {
				buffer.append(menu.getShortName());
				buffer.append(" ");
			}
		}
		return buffer.toString();
	}

	/**
	 * 合計金額:表示専用.
	 * 
	 * @return
	 */
	public int getSumPrice() {
		int ret = 0;
		for (int i = 0; i < items.size(); i++) {
			if (items.get(i).isCancel() != null && !items.get(i).isCancel()) {
				ret += items.get(i).getPrice();
			}
		}
		return ret;
	}

	/**
	 * 注文日:表示専用.
	 * 
	 * @return
	 */
	public String getOrderDate() {
		String date = "--------";
		if (getOrder().getOrderDate() != null) {
			SimpleDateFormat format = new SimpleDateFormat("MM/dd HH:mm");
			date = format.format(getOrder().getOrderDate());
		}
		return date;
	}

	/**
	 * 品目略名:表示専用.
	 * 
	 * @return
	 */
	public String getMenus() {
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i < items.size(); i++) {
			OrderItem item = items.get(i);
			if (item != null) {
				if (item.getShortName() != null) {
					buffer.append(item.getShortName());
				}
				buffer.append(" ");
			}
		}
		return buffer.toString();

	}

	public boolean isTakeOut() {
		return takeOut;
	}

	public void setTakeOut(boolean isTakeOut) {
		this.takeOut = isTakeOut;
	}

}
