package jp.bne.deno.ordermaid.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * 注文情報クラス
 * 
 * @author hasegawt
 * 
 */
@Entity
public class OrderData implements Serializable, Cloneable {

	private static final long serialVersionUID = 1L;

	@OneToMany(mappedBy = "order", cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	private List<OrderDetail> details = new ArrayList<OrderDetail>();

	@Temporal(value = TemporalType.TIMESTAMP)
	private Date orderDate;

	@Id
	@GeneratedValue
	private int orderId = -1;

	private String version = "a";

	public List<OrderDetail> getDetails() {
		return details;
	}

	public Date getOrderDate() {
		return orderDate;
	}

	public int getOrderId() {
		return orderId;
	}

	public String getVersion() {
		return version;
	}

	public void setDetails(List<OrderDetail> details) {
		this.details = details;
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public void setOrderId(int orderId) {
		this.orderId = orderId;
	}

	public void setVersion(String version) {
		this.version = version;
	}

}
