package jp.bne.deno.ordermaid.dao;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

import org.apache.log4j.Logger;

import jp.bne.deno.ordermaid.model.MenuType;

import com.google.inject.Inject;

public class MenuTypeTable {
	@Inject
	EntityManager em;

	Logger logger = Logger.getLogger(MenuTypeTable.class);

	private MenuType find(int menuTypeId) {
		return em.find(MenuType.class, menuTypeId);
	}

	@SuppressWarnings("unchecked")
	public List<MenuType> findAll() {
		String jpql = "FROM  MenuType m ORDER BY sort";
		return em.createQuery(jpql).getResultList();
	}

	public MenuType save(MenuType menuType) {
		EntityTransaction transaction = em.getTransaction();
		transaction.begin();
		try {
			em.persist(menuType);
			em.flush();
			transaction.commit();
		} catch (Throwable e) {
			logger.error(e);
			transaction.rollback();
		}
		return menuType;
	}

	public void remove(int menuTypeId) {
		EntityTransaction transaction = em.getTransaction();
		transaction.begin();
		try {
			em.remove(find(menuTypeId));
			em.flush();
			transaction.commit();
		} catch (Throwable e) {
			logger.error(e);
			transaction.rollback();
		}
	}
}
