/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.RowIndex;
import org.h2.index.ScanCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Storage;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueLob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanIndex
extends BaseIndex
implements RowIndex {
    private long firstFree = -1L;
    private ObjectArray<Row> rows = ObjectArray.newInstance();
    private Storage storage;
    private TableData tableData;
    private int rowCountDiff;
    private HashMap<Integer, Integer> sessionRowCount;
    private HashSet<Row> delta;
    private long rowCount;

    public ScanIndex(TableData tableData, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(tableData, n, tableData.getName() + "_TABLE_SCAN", indexColumnArray, indexType);
        if (this.database.isMultiVersion()) {
            this.sessionRowCount = New.hashMap();
        }
        this.tableData = tableData;
        if (!this.database.isPersistent() || n < 0 || !indexType.isPersistent()) {
            return;
        }
        this.storage = this.database.getStorage(tableData, n, true);
        int n2 = this.storage.getRecordCount();
        this.rowCount = n2;
        tableData.setRowCount(n2);
        this.trace.info("open existing " + tableData.getName() + " rows: " + n2);
    }

    @Override
    public void remove(Session session) throws SQLException {
        this.truncate(session);
        if (this.storage != null) {
            this.storage.truncate(session);
            this.database.removeStorage(this.storage.getId(), this.storage.getDiskFile());
        }
    }

    @Override
    public void truncate(Session session) throws SQLException {
        if (this.storage == null) {
            this.rows = ObjectArray.newInstance();
            this.firstFree = -1L;
        } else {
            this.storage.truncate(session);
        }
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        this.tableData.setRowCount(0L);
        this.rowCount = 0L;
        if (this.database.isMultiVersion()) {
            this.sessionRowCount.clear();
        }
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void close(Session session) {
        if (this.storage != null) {
            this.storage = null;
        }
    }

    @Override
    public Row getRow(Session session, long l) throws SQLException {
        if (this.storage != null) {
            return (Row)this.storage.getRecord(session, (int)l);
        }
        return this.rows.get((int)l);
    }

    @Override
    public void add(Session session, Row row) throws SQLException {
        int n;
        if (this.storage != null) {
            if (this.tableData.getContainsLargeObject()) {
                for (n = 0; n < row.getColumnCount(); ++n) {
                    Value value = row.getValue(n);
                    Value value2 = value.link(this.database, this.getId());
                    if (value2.isLinked()) {
                        session.unlinkAtCommitStop(value2);
                    }
                    if (value == value2) continue;
                    row.setValue(n, value2);
                }
            }
            this.storage.addRecord(session, row, -1);
        } else {
            if (this.firstFree == -1L) {
                int n2 = this.rows.size();
                row.setKey(n2);
                row.setPos(n2);
                this.rows.add(row);
            } else {
                long l = this.firstFree;
                Row row2 = this.rows.get((int)l);
                this.firstFree = row2.getKey();
                row.setPos((int)l);
                row.setKey(l);
                this.rows.set((int)l, row);
            }
            row.setDeleted(false);
        }
        if (this.database.isMultiVersion()) {
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if ((n = (int)(this.delta.remove(row) ? 1 : 0)) == 0) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), 1);
        }
        ++this.rowCount;
    }

    @Override
    public void commit(int n, Row row) {
        if (this.database.isMultiVersion()) {
            if (this.delta != null) {
                this.delta.remove(row);
            }
            this.incrementRowCount(row.getSessionId(), n == 1 ? 1 : -1);
        }
    }

    private void incrementRowCount(int n, int n2) {
        if (this.database.isMultiVersion()) {
            Integer n3 = n;
            Integer n4 = this.sessionRowCount.get(n3);
            int n5 = n4 == null ? 0 : n4;
            this.sessionRowCount.put(n3, n5 + n2);
            this.rowCountDiff += n2;
        }
    }

    @Override
    public void remove(Session session, Row row) throws SQLException {
        int n;
        if (this.storage != null) {
            this.storage.removeRecord(session, (int)row.getKey());
            if (this.tableData.getContainsLargeObject()) {
                for (n = 0; n < row.getColumnCount(); ++n) {
                    Value value = row.getValue(n);
                    if (!value.isLinked()) continue;
                    session.unlinkAtCommit((ValueLob)value);
                }
            }
        } else if (!this.database.isMultiVersion() && this.rowCount == 1L) {
            this.rows = ObjectArray.newInstance();
            this.firstFree = -1L;
        } else {
            Row row2 = new Row(null, 0);
            row2.setPos((int)this.firstFree);
            row2.setKey(this.firstFree);
            long l = row.getKey();
            this.rows.set((int)l, row2);
            this.firstFree = l;
        }
        if (this.database.isMultiVersion()) {
            row.setDeleted(true);
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if ((n = (int)(this.delta.remove(row) ? 1 : 0)) == 0) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), -1);
        }
        --this.rowCount;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return new ScanCursor(session, this, this.database.isMultiVersion());
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        long l = this.tableData.getRowCountApproximation() + 1000L;
        if (this.storage != null) {
            l *= 10L;
        }
        return l;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            Integer n = this.sessionRowCount.get(session.getId());
            long l = n == null ? 0L : (long)n.intValue();
            l += this.rowCount;
            return l -= (long)this.rowCountDiff;
        }
        return this.rowCount;
    }

    Row getNextRow(Session session, Row row) throws SQLException {
        if (this.storage == null) {
            long l = row == null ? -1L : row.getKey();
            do {
                if (++l < (long)this.rows.size()) continue;
                return null;
            } while ((row = this.rows.get((int)l)).isEmpty());
            return row;
        }
        int n = this.storage.getNext(row);
        if (n < 0) {
            return null;
        }
        return (Row)this.storage.getRecord(session, n);
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("SCAN");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("SCAN");
    }

    Iterator<Row> getDelta() {
        if (this.delta == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.delta.iterator();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

