/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.util.Iterator;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionResourceNameIterator
implements Iterator<String> {
    private final String path;
    private final String[] extensions;
    private int index;

    public ExtensionResourceNameIterator(String path, String extension) {
        if (extension == null && path.indexOf(46) != -1) {
            this.extensions = new String[]{"." + Strings.lastPathComponent(path, '.')};
            path = Strings.beforeLastPathComponent(path, '.');
        } else if (extension != null) {
            this.extensions = Strings.split(extension, ',');
            for (int i = this.extensions.length - 1; i >= 0; --i) {
                this.extensions[i] = this.extensions[i].trim();
                if (this.extensions[i].startsWith(".")) continue;
                this.extensions[i] = "." + this.extensions[i];
            }
        } else {
            this.extensions = new String[1];
            this.extensions[0] = ".";
        }
        this.path = path;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.extensions.length;
    }

    @Override
    public String next() {
        return this.path + this.extensions[this.index++];
    }

    @Override
    public void remove() {
    }
}

