/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.license;

import java.io.File;
import junit.framework.Assert;
import org.apache.wicket.util.diff.Diff;
import org.apache.wicket.util.diff.Revision;
import org.apache.wicket.util.license.AbstractLicenseHeaderHandler;

class CssLicenseHeaderHandler
extends AbstractLicenseHeaderHandler {
    public CssLicenseHeaderHandler(String[] ignoreFiles) {
        super(ignoreFiles);
    }

    protected String getLicenseHeaderFilename() {
        return "cssLicense.txt";
    }

    public boolean checkLicenseHeader(File file) {
        Revision revision = null;
        try {
            String header = this.extractLicenseHeader(file, 0, 16);
            revision = Diff.diff(this.getLicenseHeader().split(LINE_ENDING), header.split(LINE_ENDING));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return revision.size() == 0;
    }

    public String[] getSuffixes() {
        return new String[]{"css"};
    }

    public boolean addLicenseHeader(File file) {
        this.prependLicenseHeader(file);
        return true;
    }
}

