/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.crypt;

public class Base64UrlSafe {
    static final int BASELENGTH = 255;
    static final int LOOKUPLENGTH = 64;
    static final int EIGHTBIT = 8;
    static final int SIXTEENBIT = 16;
    static final int TWENTYFOURBITGROUP = 24;
    static final int FOURBYTE = 4;
    static final int SIGN = -128;
    private static byte[] base64Alphabet;
    private static byte[] lookUpBase64Alphabet;

    private static boolean isBase64(byte octet) {
        return octet >= 0 && base64Alphabet[octet] != -1;
    }

    public static boolean isArrayByteBase64(byte[] arrayOctect) {
        int length = (arrayOctect = Base64UrlSafe.discardWhitespace(arrayOctect)).length;
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Base64UrlSafe.isBase64(arrayOctect[i])) continue;
            return false;
        }
        return true;
    }

    public Object decode(Object pObject) {
        if (!(pObject instanceof byte[])) {
            throw new IllegalArgumentException("Parameter supplied to Base64 decode is not a byte[]");
        }
        return this.decode((byte[])pObject);
    }

    public byte[] decode(byte[] pArray) {
        return Base64UrlSafe.decodeBase64(pArray);
    }

    public static byte[] encodeBase64(byte[] binaryData) {
        byte val2;
        byte val1;
        int lengthDataBits = binaryData.length * 8;
        int fewerThan24bits = lengthDataBits % 24;
        int numberTriplets = lengthDataBits / 24;
        byte[] encodedData = null;
        int encodedDataLength = 0;
        encodedDataLength = fewerThan24bits != 0 ? (numberTriplets + 1) * 4 : numberTriplets * 4;
        if (fewerThan24bits == 8) {
            encodedDataLength -= 2;
        } else if (fewerThan24bits == 16) {
            --encodedDataLength;
        }
        encodedData = new byte[encodedDataLength];
        byte k = 0;
        byte l = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        int i = 0;
        for (i = 0; i < numberTriplets; ++i) {
            dataIndex = i * 3;
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            b3 = binaryData[dataIndex + 2];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l << 2 | val3];
            encodedData[encodedIndex + 3] = lookUpBase64Alphabet[b3 & 0x3F];
            encodedIndex += 4;
        }
        dataIndex = i * 3;
        if (fewerThan24bits == 8) {
            b1 = binaryData[dataIndex];
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[k << 4];
        } else if (fewerThan24bits == 16) {
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l << 2];
        }
        return encodedData;
    }

    public static byte[] decodeBase64(byte[] base64Data) {
        if ((base64Data = Base64UrlSafe.discardNonBase64(base64Data)).length == 0) {
            return new byte[0];
        }
        int numberQuadruple = (base64Data.length + 3) / 4;
        byte[] decodedData = new byte[base64Data.length - numberQuadruple];
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        byte b4 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        for (int i = 0; i < numberQuadruple; ++i) {
            dataIndex = i * 4;
            b1 = base64Alphabet[base64Data[dataIndex]];
            b2 = base64Alphabet[base64Data[dataIndex + 1]];
            if (dataIndex + 3 < base64Data.length) {
                b3 = base64Alphabet[base64Data[dataIndex + 2]];
                b4 = base64Alphabet[base64Data[dataIndex + 3]];
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                decodedData[encodedIndex + 2] = (byte)(b3 << 6 | b4);
            } else if (dataIndex + 2 < base64Data.length) {
                b3 = base64Alphabet[base64Data[dataIndex + 2]];
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
            } else if (dataIndex + 1 < base64Data.length) {
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
            }
            encodedIndex += 3;
        }
        return decodedData;
    }

    static byte[] discardWhitespace(byte[] data) {
        byte[] groomedData = new byte[data.length];
        int bytesCopied = 0;
        block3: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
                default: {
                    groomedData[bytesCopied++] = data[i];
                }
            }
        }
        byte[] packedData = new byte[bytesCopied];
        System.arraycopy(groomedData, 0, packedData, 0, bytesCopied);
        return packedData;
    }

    static byte[] discardNonBase64(byte[] data) {
        byte[] groomedData = new byte[data.length];
        int bytesCopied = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Base64UrlSafe.isBase64(data[i])) continue;
            groomedData[bytesCopied++] = data[i];
        }
        byte[] packedData = new byte[bytesCopied];
        System.arraycopy(groomedData, 0, packedData, 0, bytesCopied);
        return packedData;
    }

    public Object encode(Object pObject) {
        if (!(pObject instanceof byte[])) {
            throw new IllegalArgumentException("Parameter supplied to Base64 encode is not a byte[]");
        }
        return this.encode((byte[])pObject);
    }

    public byte[] encode(byte[] pArray) {
        return Base64UrlSafe.encodeBase64(pArray);
    }

    static {
        int i;
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new byte[64];
        for (i = 0; i < 255; ++i) {
            Base64UrlSafe.base64Alphabet[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            Base64UrlSafe.base64Alphabet[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            Base64UrlSafe.base64Alphabet[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            Base64UrlSafe.base64Alphabet[i] = (byte)(i - 48 + 52);
        }
        Base64UrlSafe.base64Alphabet[42] = 62;
        Base64UrlSafe.base64Alphabet[45] = 63;
        for (i = 0; i <= 25; ++i) {
            Base64UrlSafe.lookUpBase64Alphabet[i] = (byte)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i <= 51) {
            Base64UrlSafe.lookUpBase64Alphabet[i] = (byte)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i <= 61) {
            Base64UrlSafe.lookUpBase64Alphabet[i] = (byte)(48 + j);
            ++i;
            ++j;
        }
        Base64UrlSafe.lookUpBase64Alphabet[62] = 42;
        Base64UrlSafe.lookUpBase64Alphabet[63] = 45;
    }
}

