/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentStringResourceLoader
implements IStringResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(ComponentStringResourceLoader.class);

    @Override
    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style) {
        if (clazz == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("key: '" + key + "'; class: '" + clazz.getName() + "'; locale: '" + locale + "'; Style: '" + style + "'");
        }
        IPropertiesFactory propertiesFactory = this.getPropertiesFactory();
        do {
            String path = clazz.getName().replace('.', '/');
            ResourceNameIterator iter = new ResourceNameIterator(path, style, locale, null);
            while (iter.hasNext()) {
                String newPath = iter.next();
                Properties props = propertiesFactory.load(clazz, newPath);
                if (props != null) {
                    String value = props.getString(key);
                    if (value != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Found property '" + key + "' in: '" + props + "'" + "; value: '" + value + "'");
                        }
                        return value;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Found properties file: '" + newPath + "' but it doesn't contain the property");
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
            }
        } while (!this.isStopResourceSearch(clazz) && (clazz = clazz.getSuperclass()) != null);
        return null;
    }

    protected IPropertiesFactory getPropertiesFactory() {
        return Application.get().getResourceSettings().getPropertiesFactory();
    }

    @Override
    public String loadStringResource(Component component, String key) {
        if (component == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("component: '" + component.toString(false) + "'; key: '" + key + "'");
        }
        String string = null;
        Locale locale = component.getLocale();
        String style = component.getStyle();
        String prefix = ((Object)Strings.replaceAll(component.getPageRelativePath(), ":", ".")).toString();
        List<Class<?>> searchStack = this.getComponentStack(component);
        boolean old = true;
        for (int i = searchStack.size() - 1; i >= 0 && string == null; --i) {
            Class<?> clazz = searchStack.get(i);
            if (prefix != null && prefix.length() > 0 && (string = this.loadStringResource(clazz, prefix + '.' + key, locale, style)) == null) {
                prefix = Strings.afterFirst(prefix, '.');
            }
            if (string != null) continue;
            string = this.loadStringResource(clazz, key, locale, style);
        }
        if (string == null) {
            // empty if block
        }
        return string;
    }

    private List<Class<?>> getComponentStack(Component component) {
        ArrayList searchStack = new ArrayList();
        searchStack.add(component.getClass());
        if (!(component instanceof Page)) {
            for (MarkupContainer container = component.getParent(); container != null; container = container.getParent()) {
                searchStack.add(container.getClass());
                if (container instanceof Page) break;
            }
        }
        return searchStack;
    }

    protected boolean isStopResourceSearch(Class<?> clazz) {
        if (clazz == null || clazz.equals(Object.class) || clazz.equals(Application.class)) {
            return true;
        }
        if (clazz.equals(WebPage.class) || clazz.equals(WebMarkupContainer.class) || clazz.equals(WebComponent.class)) {
            return true;
        }
        return clazz.equals(Page.class) || clazz.equals(MarkupContainer.class) || clazz.equals(Component.class);
    }
}

