/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.IMultipartWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.upload.DiskFileItemFactory;
import org.apache.wicket.util.upload.FileItem;
import org.apache.wicket.util.upload.FileItemFactory;
import org.apache.wicket.util.upload.FileUploadException;
import org.apache.wicket.util.upload.ServletFileUpload;
import org.apache.wicket.util.upload.ServletRequestContext;
import org.apache.wicket.util.value.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartServletWebRequest
extends ServletWebRequest
implements IMultipartWebRequest {
    private final Map<String, FileItem> files = new HashMap<String, FileItem>();
    private final ValueMap parameters = new ValueMap();
    private int bytesUploaded;
    private int totalBytes;

    public MultipartServletWebRequest(HttpServletRequest request, Bytes maxSize) throws FileUploadException {
        this(request, maxSize, new DiskFileItemFactory());
    }

    public MultipartServletWebRequest(HttpServletRequest request, Bytes maxSize, FileItemFactory factory) throws FileUploadException {
        super(request);
        List<FileItem> items;
        if (maxSize == null) {
            throw new IllegalArgumentException("argument maxSize must be not null");
        }
        boolean isMultipart = ServletFileUpload.isMultipartContent(request);
        if (!isMultipart) {
            throw new IllegalStateException("ServletRequest does not contain multipart content. One possible solution is to explicitly call Form.setMultipart(true), Wicket tries its best to auto-detect multipart forms but there are certain situation where it cannot.");
        }
        ServletFileUpload upload = new ServletFileUpload(factory);
        String encoding = request.getCharacterEncoding();
        if (encoding != null) {
            upload.setHeaderEncoding(encoding);
        }
        upload.setSizeMax(maxSize.bytes());
        if (this.wantUploadProgressUpdates()) {
            ServletRequestContext ctx = new ServletRequestContext(request){

                public InputStream getInputStream() throws IOException {
                    return new CountingInputStream(super.getInputStream());
                }
            };
            this.totalBytes = request.getContentLength();
            this.onUploadStarted(this.totalBytes);
            items = upload.parseRequest(ctx);
            this.onUploadCompleted();
        } else {
            items = upload.parseRequest(request);
        }
        for (FileItem item : items) {
            if (item.isFormField()) {
                String value;
                if (encoding != null) {
                    try {
                        value = item.getString(encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new WicketRuntimeException(e);
                    }
                } else {
                    value = item.getString();
                }
                this.addParameter(item.getFieldName(), value);
                continue;
            }
            this.files.put(item.getFieldName(), item);
        }
    }

    private void addParameter(String name, String value) {
        String[] currVal = (String[])this.parameters.get(name);
        String[] newVal = null;
        if (currVal != null) {
            newVal = new String[currVal.length + 1];
            System.arraycopy(currVal, 0, newVal, 0, currVal.length);
            newVal[currVal.length] = value;
        } else {
            newVal = new String[]{value};
        }
        this.parameters.put(name, (Object)newVal);
    }

    @Override
    public Map<String, FileItem> getFiles() {
        return this.files;
    }

    @Override
    public FileItem getFile(String fieldName) {
        return this.files.get(fieldName);
    }

    @Override
    public String getParameter(String key) {
        String[] val = (String[])this.parameters.get(key);
        return val == null ? null : val[0];
    }

    @Override
    public Map getParameterMap() {
        return this.parameters;
    }

    @Override
    public String[] getParameters(String key) {
        return (String[])this.parameters.get(key);
    }

    protected boolean wantUploadProgressUpdates() {
        return false;
    }

    protected void onUploadStarted(int totalBytes) {
    }

    protected void onUploadUpdate(int bytesUploaded, int total) {
    }

    protected void onUploadCompleted() {
    }

    private class CountingInputStream
    extends InputStream {
        private final InputStream in;

        public CountingInputStream(InputStream in) {
            this.in = in;
        }

        public int read() throws IOException {
            int read = this.in.read();
            MultipartServletWebRequest.this.bytesUploaded += read < 0 ? 0 : 1;
            MultipartServletWebRequest.this.onUploadUpdate(MultipartServletWebRequest.this.bytesUploaded, MultipartServletWebRequest.this.totalBytes);
            return read;
        }

        public int read(byte[] b) throws IOException {
            int read = this.in.read(b);
            MultipartServletWebRequest.this.bytesUploaded += read < 0 ? 0 : read;
            MultipartServletWebRequest.this.onUploadUpdate(MultipartServletWebRequest.this.bytesUploaded, MultipartServletWebRequest.this.totalBytes);
            return read;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.in.read(b, off, len);
            MultipartServletWebRequest.this.bytesUploaded += read < 0 ? 0 : read;
            MultipartServletWebRequest.this.onUploadUpdate(MultipartServletWebRequest.this.bytesUploaded, MultipartServletWebRequest.this.totalBytes);
            return read;
        }
    }
}

