/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketURLEncoder {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    protected BitSet dontNeedEncoding;
    private final char stopChar;
    protected static final int caseDiff = 32;
    public static final WicketURLEncoder QUERY_INSTANCE = new WicketURLEncoder(Type.QUERY, '\u0000');
    public static final WicketURLEncoder PATH_INSTANCE = new WicketURLEncoder(Type.PATH, '\u0000');
    public static final WicketURLEncoder FULL_PATH_INSTANCE = new WicketURLEncoder(Type.FULL_PATH, '?');

    protected WicketURLEncoder(Type type, char stopChar) {
        int i;
        this.stopChar = stopChar;
        this.dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            this.dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            this.dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            this.dontNeedEncoding.set(i);
        }
        this.dontNeedEncoding.set(45);
        this.dontNeedEncoding.set(46);
        this.dontNeedEncoding.set(95);
        this.dontNeedEncoding.set(126);
        this.dontNeedEncoding.set(33);
        this.dontNeedEncoding.set(36);
        this.dontNeedEncoding.set(39);
        this.dontNeedEncoding.set(42);
        this.dontNeedEncoding.set(44);
        this.dontNeedEncoding.set(58);
        this.dontNeedEncoding.set(64);
        switch (type) {
            case QUERY: {
                this.dontNeedEncoding.set(32);
                this.dontNeedEncoding.set(47);
                this.dontNeedEncoding.set(63);
                break;
            }
            case PATH: {
                this.dontNeedEncoding.set(38);
                this.dontNeedEncoding.set(61);
                this.dontNeedEncoding.set(43);
                break;
            }
            case FULL_PATH: {
                this.dontNeedEncoding.set(38);
                this.dontNeedEncoding.set(61);
                this.dontNeedEncoding.set(43);
                this.dontNeedEncoding.set(47);
            }
        }
    }

    public String encode(String s) {
        Application app = null;
        try {
            app = Application.get();
        }
        catch (WicketRuntimeException ignored) {
            log.warn("No current Application found - defaulting encoding to UTF-8");
        }
        return this.encode(s, app == null ? "UTF-8" : app.getRequestCycleSettings().getResponseRequestEncoding());
    }

    public String encode(String s, String enc) {
        Charset charset;
        boolean needToChange = false;
        StringBuffer out = new StringBuffer(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        if (enc == null) {
            throw new NullPointerException("charsetName");
        }
        try {
            charset = Charset.forName(enc);
        }
        catch (IllegalCharsetNameException e) {
            throw new WicketRuntimeException(new UnsupportedEncodingException(enc));
        }
        catch (UnsupportedCharsetException e) {
            throw new WicketRuntimeException(new UnsupportedEncodingException(enc));
        }
        boolean stopEncoding = false;
        int i = 0;
        while (i < s.length()) {
            char c;
            char c2 = s.charAt(i);
            if (!stopEncoding && c2 == this.stopChar) {
                stopEncoding = true;
            }
            if (stopEncoding || this.dontNeedEncoding.get(c2)) {
                if (c2 == ' ') {
                    c2 = '+';
                    needToChange = true;
                }
                out.append(c2);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c2);
                if (c2 >= '\ud800' && c2 <= '\udbff' && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    charArrayWriter.write(d);
                    ++i;
                }
                if (++i >= s.length()) break;
                c = s.charAt(i);
                c2 = c;
            } while (!this.dontNeedEncoding.get(c));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = new byte[]{};
            try {
                ba = str.getBytes(charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new WicketRuntimeException(e);
            }
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        QUERY,
        PATH,
        FULL_PATH;

    }
}

