/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater.data;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDataProvider<T extends Serializable>
implements IDataProvider<T> {
    private static final long serialVersionUID = 1L;
    private final List<T> list;

    public ListDataProvider(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("argument [list] cannot be null");
        }
        this.list = list;
    }

    @Override
    public Iterator<? extends T> iterator(int first, int count) {
        int toIndex = first + count;
        if (toIndex > this.list.size()) {
            toIndex = this.list.size();
        }
        return this.list.subList(first, toIndex).listIterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public IModel<T> model(T object) {
        return new Model<T>(object);
    }

    @Override
    public void detach() {
    }
}

