/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelativePathPrefixHandler
extends AbstractMarkupFilter
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RelativePathPrefixHandler.class);
    public static final String WICKET_RELATIVE_PATH_PREFIX_CONTAINER_ID = "_relative_path_prefix_";
    private static final String[] attributeNames = new String[]{"href", "src", "background", "action"};
    public static final IBehavior RELATIVE_PATH_BEHAVIOR = new AbstractBehavior(){
        private static final long serialVersionUID = 1L;

        public void onComponentTag(Component component, ComponentTag tag) {
            IRequestCodingStrategy coder = RequestCycle.get().getProcessor().getRequestCodingStrategy();
            for (int i = 0; i < attributeNames.length; ++i) {
                String attrName = attributeNames[i];
                String attrValue = tag.getAttributes().getString(attrName);
                if (attrValue == null || attrValue.startsWith("/") || attrValue.indexOf(":") >= 0 || attrValue.startsWith("#")) continue;
                tag.getAttributes().put(attrName, coder.rewriteStaticRelativeUrl(attrValue));
            }
        }
    };

    public MarkupElement nextTag() throws ParseException {
        ComponentTag tag = (ComponentTag)this.getParent().nextTag();
        if (tag == null || tag.isClose()) {
            return tag;
        }
        if (tag instanceof WicketTag || tag.isAutolinkEnabled() || tag.getAttributes().get("wicket:id") != null) {
            return tag;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            String attrName = attributeNames[i];
            String attrValue = tag.getAttributes().getString(attrName);
            if (attrValue == null || attrValue.startsWith("/") || attrValue.indexOf(":") >= 0 || attrValue.startsWith("#")) continue;
            if (tag.getId() == null) {
                tag.setId(WICKET_RELATIVE_PATH_PREFIX_CONTAINER_ID);
                tag.setAutoComponentTag(true);
            }
            tag.addBehavior(RELATIVE_PATH_BEHAVIOR);
            tag.setModified(true);
            break;
        }
        return tag;
    }

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (WICKET_RELATIVE_PATH_PREFIX_CONTAINER_ID.equals(tag.getId())) {
            String id = WICKET_RELATIVE_PATH_PREFIX_CONTAINER_ID + container.getPage().getAutoIndex();
            Component wc = tag.isOpenClose() ? new WebComponent(id) : new WebMarkupContainer(id){
                private static final long serialVersionUID = 1L;

                public boolean isTransparentResolver() {
                    return true;
                }
            };
            container.autoAdd(wc, markupStream);
            return true;
        }
        return false;
    }
}

