/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.XmlTag;

public class OpenCloseTagExpander
extends AbstractMarkupFilter {
    private static final List<String> replaceForTags = Arrays.asList("div", "span", "p", "strong", "b", "e", "select");
    private ComponentTag next = null;

    public MarkupElement nextTag() throws ParseException {
        if (this.next != null) {
            ComponentTag tmp = this.next;
            this.next = null;
            return tmp;
        }
        ComponentTag tag = this.nextComponentTag();
        if (tag == null) {
            return tag;
        }
        if (tag.isOpenClose()) {
            String name = tag.getName();
            if (tag.getNamespace() != null) {
                name = tag.getNamespace() + ":" + tag.getName();
            }
            if (this.contains(name) && this.onFound(tag)) {
                this.next = new ComponentTag(tag.getName(), XmlTag.CLOSE);
                this.next.setNamespace(tag.getNamespace());
                this.next.setOpenTag(tag);
                this.next.setModified(true);
            }
        }
        return tag;
    }

    protected boolean onFound(ComponentTag tag) {
        tag.setType(XmlTag.OPEN);
        tag.setModified(true);
        return true;
    }

    protected boolean contains(String name) {
        return replaceForTags.contains(name.toLowerCase());
    }
}

