/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser;

import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.TagAttributes;
import org.apache.wicket.util.lang.EnumeratedType;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTag
extends MarkupElement {
    private static final Logger log = LoggerFactory.getLogger(XmlTag.class);
    public static final Type CLOSE = new Type("CLOSE");
    public static final Type OPEN = new Type("OPEN");
    public static final Type OPEN_CLOSE = new Type("OPEN_CLOSE");
    private IValueMap attributes;
    int columnNumber;
    int length;
    int lineNumber;
    String name;
    String namespace;
    int pos;
    CharSequence text;
    Type type;
    private XmlTag closes;
    private XmlTag copyOf = this;
    private boolean isMutable = true;
    private boolean nameChanged = false;

    public final boolean closes(XmlTag open) {
        return this.closes == open || this.closes == open.copyOf;
    }

    @Override
    public final boolean equalTo(MarkupElement element) {
        if (element instanceof XmlTag) {
            XmlTag that = (XmlTag)element;
            if (!Objects.equal(this.getNamespace(), that.getNamespace())) {
                return false;
            }
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            return this.getAttributes().equals(that.getAttributes());
        }
        return false;
    }

    public IValueMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.copyOf == this || this.copyOf == null || this.copyOf.attributes == null ? new TagAttributes() : new TagAttributes((Map)this.copyOf.attributes);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.size() > 0;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLength() {
        return this.length;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getName() {
        return this.name;
    }

    public boolean getNameChanged() {
        return this.nameChanged;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public final XmlTag getOpenTag() {
        return this.closes;
    }

    public int getPos() {
        return this.pos;
    }

    public CharSequence getString(String key) {
        return this.getAttributes().getCharSequence(key);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isClose() {
        return this.type == CLOSE;
    }

    public final boolean isMutable() {
        return this.isMutable;
    }

    public boolean isOpen() {
        return this.type == OPEN;
    }

    public boolean isOpenClose() {
        return this.type == OPEN_CLOSE;
    }

    public boolean hasEqualTagName(XmlTag tag) {
        if (!this.getName().equalsIgnoreCase(tag.getName())) {
            return false;
        }
        if (this.getNamespace() == null && tag.getNamespace() == null) {
            return true;
        }
        if (this.getNamespace() != null && tag.getNamespace() != null) {
            return this.getNamespace().equalsIgnoreCase(tag.getNamespace());
        }
        return false;
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
            if (this.attributes != null) {
                this.attributes.makeImmutable();
                this.text = null;
            }
        }
    }

    public XmlTag mutable() {
        if (this.isMutable) {
            return this;
        }
        XmlTag tag = new XmlTag();
        this.copyPropertiesTo(tag);
        return tag;
    }

    void copyPropertiesTo(XmlTag dest) {
        dest.namespace = this.namespace;
        dest.name = this.name;
        dest.pos = this.pos;
        dest.length = this.length;
        dest.text = this.text;
        dest.type = this.type;
        dest.isMutable = true;
        dest.closes = this.closes;
        dest.copyOf = this.copyOf;
        if (this.attributes != null) {
            dest.attributes = new ValueMap(this.attributes);
        }
    }

    public Object put(String key, boolean value) {
        return this.put(key, Boolean.toString(value));
    }

    public Object put(String key, int value) {
        return this.put(key, Integer.toString(value));
    }

    public Object put(String key, CharSequence value) {
        return this.getAttributes().put(key, value);
    }

    public Object put(String key, StringValue value) {
        return this.getAttributes().put(key, value != null ? value.toString() : null);
    }

    public void putAll(Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, Object> entry;
            this.put(entry.getKey(), (value = (entry = iterator.next()).getValue()) != null ? value.toString() : null);
        }
    }

    public void remove(String key) {
        this.getAttributes().remove(key);
    }

    public void setName(String name) {
        if (!this.isMutable) {
            throw new UnsupportedOperationException("Attempt to set name of immutable tag");
        }
        this.name = name;
        this.nameChanged = true;
    }

    public void setNamespace(String namespace) {
        if (!this.isMutable) {
            throw new UnsupportedOperationException("Attempt to set namespace of immutable tag");
        }
        this.namespace = namespace;
        this.nameChanged = true;
    }

    public void setOpenTag(XmlTag tag) {
        this.closes = tag;
    }

    public void setType(Type type) {
        if (!this.isMutable) {
            throw new UnsupportedOperationException("Attempt to set type of immutable tag");
        }
        this.type = type;
    }

    public String toDebugString() {
        return "[Tag name = " + this.name + ", pos = " + this.pos + ", line = " + this.lineNumber + ", length = " + this.length + ", attributes = [" + this.getAttributes() + "], type = " + this.type + "]";
    }

    public String toString() {
        return ((Object)this.toCharSequence()).toString();
    }

    @Override
    public CharSequence toCharSequence() {
        if (!this.isMutable && this.text != null) {
            return this.text;
        }
        return this.toXmlString(null);
    }

    @Override
    public String toUserDebugString() {
        return "'" + this.toString() + "' (line " + this.lineNumber + ", column " + this.columnNumber + ")";
    }

    public CharSequence toXmlString(String attributeToBeIgnored) {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append('<');
        if (this.type == CLOSE) {
            buffer.append('/');
        }
        if (this.namespace != null) {
            buffer.append(this.namespace);
            buffer.append(':');
        }
        buffer.append(this.name);
        IValueMap attributes = this.getAttributes();
        if (attributes.size() > 0) {
            for (String key : attributes.keySet()) {
                if (key == null || attributeToBeIgnored != null && key.equalsIgnoreCase(attributeToBeIgnored)) continue;
                buffer.append(" ");
                buffer.append(key);
                CharSequence value = this.getString(key);
                if (value == null) continue;
                buffer.append("=\"");
                value = Strings.replaceAll(value, "\"", "\\\"");
                buffer.append(value);
                buffer.append("\"");
            }
        }
        if (this.type == OPEN_CLOSE) {
            buffer.append('/');
        }
        buffer.append('>');
        return buffer;
    }

    public static final class Type
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;

        Type(String name) {
            super(name);
        }
    }
}

