/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestContext;
import org.apache.wicket.Response;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.internal.HeaderResponse;
import org.apache.wicket.response.StringResponse;

public class HtmlHeaderContainer
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private transient Map<String, List<String>> renderedComponentsPerScope;
    private transient IHeaderResponse headerResponse = null;

    public HtmlHeaderContainer(String id) {
        super(id);
        this.setRenderBodyOnly(true);
        this.setAuto(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        Response webResponse = this.getResponse();
        try {
            StringResponse response = new StringResponse();
            this.getRequestCycle().setResponse(response);
            IHeaderResponse headerResponse = this.getHeaderResponse();
            if (!response.equals(headerResponse.getResponse())) {
                this.getRequestCycle().setResponse(headerResponse.getResponse());
            }
            super.onComponentTagBody(markupStream, openTag);
            this.renderHeaderSections(this.getPage(), this);
            this.getHeaderResponse().close();
            CharSequence output = response.getBuffer();
            if (output.length() > 0) {
                if (output.charAt(0) == '\r') {
                    for (int i = 2; i < output.length(); i += 2) {
                        char ch = output.charAt(i);
                        if (ch == '\r') continue;
                        output = output.subSequence(i - 2, output.length());
                        break;
                    }
                } else if (output.charAt(0) == '\n') {
                    for (int i = 1; i < output.length(); ++i) {
                        char ch = output.charAt(i);
                        if (ch == '\n') continue;
                        output = output.subSequence(i - 1, output.length());
                        break;
                    }
                }
            }
            if (output.length() > 0) {
                if (this.renderOpenAndCloseTags()) {
                    webResponse.write("<head>");
                }
                webResponse.write(output);
                if (this.renderOpenAndCloseTags()) {
                    webResponse.write("</head>");
                }
            }
        }
        finally {
            this.getRequestCycle().setResponse(webResponse);
        }
    }

    protected boolean renderOpenAndCloseTags() {
        return true;
    }

    private final void renderHeaderSections(MarkupContainer page, final HtmlHeaderContainer container) {
        page.renderHead(container);
        page.visitChildren(new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                if (component.isVisible()) {
                    component.renderHead(container);
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    public boolean isTransparentResolver() {
        return true;
    }

    public boolean okToRenderComponent(String scope, String id) {
        List<String> componentScope;
        if (this.renderedComponentsPerScope == null) {
            this.renderedComponentsPerScope = new HashMap<String, List<String>>();
        }
        if ((componentScope = this.renderedComponentsPerScope.get(scope)) == null) {
            componentScope = new ArrayList<String>();
            this.renderedComponentsPerScope.put(scope, componentScope);
        }
        if (componentScope.contains(id)) {
            return false;
        }
        componentScope.add(id);
        return true;
    }

    protected void onDetach() {
        super.onDetach();
        this.renderedComponentsPerScope = null;
        this.headerResponse = null;
    }

    protected IHeaderResponse newHeaderResponse() {
        IHeaderResponse headerResponse = RequestContext.get().getHeaderResponse();
        if (headerResponse == null) {
            headerResponse = new HeaderResponse(){

                protected Response getRealResponse() {
                    return HtmlHeaderContainer.this.getResponse();
                }
            };
        }
        return headerResponse;
    }

    public IHeaderResponse getHeaderResponse() {
        if (this.headerResponse == null) {
            this.headerResponse = this.newHeaderResponse();
        }
        return this.headerResponse;
    }
}

