/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageId;
import org.apache.wicket.PageMap;
import org.apache.wicket.PageParameters;
import org.apache.wicket.PageReference;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.UnauthorizedActionException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.version.IPageVersionManager;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Page
extends MarkupContainer
implements IRedirectListener,
IPageMapEntry {
    public static final int LATEST_VERSION = -1;
    public static final ThreadLocal<IPageSerializer> serializer = new ThreadLocal();
    private static final short FLAG_NEW_VERSION = 1024;
    private static final int FLAG_STATELESS_HINT = 65536;
    private static final short FLAG_TRACK_CHANGES = 2048;
    private static final Logger log = LoggerFactory.getLogger(Page.class);
    private static final ConcurrentHashMap<String, Boolean> pageClassToBookmarkableCache = new ConcurrentHashMap();
    private static final long serialVersionUID = 1L;
    private short autoIndex;
    private int numericId;
    private transient IPageMap pageMap;
    private String pageMapName;
    private transient Set<Component> renderedComponents;
    private transient Boolean stateless = null;
    private IPageVersionManager versionManager;
    private PageParameters parameters;

    protected Page() {
        super(null);
        this.init();
    }

    protected Page(IModel<?> model) {
        super(null, model);
        this.init();
    }

    protected Page(IPageMap pageMap) {
        super(null);
        this.init(pageMap);
    }

    protected Page(IPageMap pageMap, IModel<?> model) {
        super(null, model);
        this.init(pageMap);
    }

    protected Page(PageParameters parameters) {
        super(null);
        this.parameters = parameters;
        this.init();
    }

    protected Page(IPageMap pageMap, PageParameters parameters) {
        super(null);
        this.parameters = parameters;
        this.init(pageMap);
    }

    public PageParameters getPageParameters() {
        return this.parameters;
    }

    public void afterCallComponent(Component component, RequestListenerInterface listener) {
    }

    public void beforeCallComponent(Component component, RequestListenerInterface listener) {
    }

    public final void componentRendered(Component component) {
        if (Application.get().getDebugSettings().getComponentUseCheck()) {
            if (this.renderedComponents == null) {
                this.renderedComponents = new HashSet<Component>();
            }
            if (!this.renderedComponents.add(component)) {
                throw new MarkupException("The component " + component + " has the same wicket:id as another component already added at the same level");
            }
            if (log.isDebugEnabled()) {
                log.debug("Rendered " + component);
            }
        }
    }

    @Override
    public void detachModels() {
        super.detachModels();
    }

    public final void dirty() {
        Session.get().dirtyPage(this);
    }

    public final void endComponentRender(Component component) {
        if (component instanceof MarkupContainer) {
            this.checkRendering((MarkupContainer)component);
        } else {
            this.renderedComponents = null;
        }
    }

    public final void expireOldestVersion() {
        if (this.versionManager != null) {
            this.versionManager.expireOldestVersion();
        }
    }

    public final int getAjaxVersionNumber() {
        return this.versionManager == null ? 0 : this.versionManager.getAjaxVersionNumber();
    }

    public final short getAutoIndex() {
        short s = this.autoIndex;
        this.autoIndex = (short)(s + 1);
        return s;
    }

    public final int getCurrentVersionNumber() {
        return this.versionManager == null ? 0 : this.versionManager.getCurrentVersionNumber();
    }

    @Override
    public final String getId() {
        return Integer.toString(this.numericId);
    }

    @Override
    public int getNumericId() {
        return this.numericId;
    }

    @Override
    public final Class<? extends Page> getPageClass() {
        return this.getClass();
    }

    public final IPageMap getPageMap() {
        if (this.pageMap == null) {
            this.pageMap = PageMap.forName(this.pageMapName);
        }
        return this.pageMap;
    }

    public IPageMapEntry getPageMapEntry() {
        return this;
    }

    public final String getPageMapName() {
        return this.pageMapName;
    }

    @Override
    public final long getSizeInBytes() {
        this.pageMap = null;
        return Objects.sizeof(this);
    }

    @Override
    public final boolean getStatelessHint() {
        return this.getFlag(65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getVersion(int versionNumber) {
        if (this.versionManager == null) {
            if (versionNumber == 0 || versionNumber == -1) {
                return this;
            }
            log.info("No version manager available to retrieve requested versionNumber " + versionNumber);
            return null;
        }
        boolean originalTrackChanges = this.getFlag((short)2048);
        try {
            this.setFlag((short)2048, false);
            Page page = versionNumber != -1 ? this.versionManager.getVersion(versionNumber) : this.versionManager.getVersion(this.getCurrentVersionNumber());
            if (page != null && page.getCurrentVersionNumber() == 0 && page.getAjaxVersionNumber() == 0) {
                page.versionManager = null;
            }
            Page page2 = page;
            return page2;
        }
        finally {
            this.setFlag((short)2048, originalTrackChanges);
        }
    }

    public final int getVersions() {
        return this.versionManager == null ? 1 : this.versionManager.getVersions() + 1;
    }

    public final String hierarchyAsString() {
        final StringBuffer buffer = new StringBuffer();
        buffer.append("Page " + this.getId() + " (version " + this.getCurrentVersionNumber() + ")");
        this.visitChildren(new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                int levels = 0;
                for (Component current = component; current != null; current = current.getParent()) {
                    ++levels;
                }
                buffer.append(StringValue.repeat(levels, "\t") + component.getPageRelativePath() + ":" + Classes.simpleName(component.getClass()));
                return null;
            }
        });
        return buffer.toString();
    }

    public final void ignoreVersionMerge() {
        if (this.getRequest().mergeVersion()) {
            this.mayTrackChangesFor(this, null);
            if (this.versionManager != null) {
                this.versionManager.ignoreVersionMerge();
            }
        }
    }

    public boolean isBookmarkable() {
        Boolean bookmarkable = pageClassToBookmarkableCache.get(this.getClass().getName());
        if (bookmarkable == null) {
            try {
                if (this.getClass().getConstructor(new Class[0]) != null) {
                    bookmarkable = Boolean.TRUE;
                }
            }
            catch (Exception ignore) {
                try {
                    if (this.getClass().getConstructor(PageParameters.class) != null) {
                        bookmarkable = Boolean.TRUE;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bookmarkable == null) {
                bookmarkable = Boolean.FALSE;
            }
            pageClassToBookmarkableCache.put(this.getClass().getName(), bookmarkable);
        }
        return bookmarkable;
    }

    public boolean isErrorPage() {
        return false;
    }

    private boolean peekPageStateless() {
        Boolean old = this.stateless;
        Boolean res = this.isPageStateless();
        this.stateless = old;
        return res;
    }

    public final boolean isPageStateless() {
        if (!this.isBookmarkable()) {
            this.stateless = Boolean.FALSE;
            if (this.getStatelessHint()) {
                log.warn("Page '" + this + "' is not stateless because it is not bookmarkable, " + "but the stateless hint is set to true!");
            }
        }
        if (!this.getStatelessHint()) {
            return false;
        }
        if (this.stateless == null && !this.isStateless()) {
            this.stateless = Boolean.FALSE;
        }
        if (this.stateless == null) {
            final Object[] returnArray = new Object[1];
            Object returnValue = this.visitChildren(Component.class, new Component.IVisitor<Component>(){

                @Override
                public Object component(Component component) {
                    if (!component.isStateless()) {
                        returnArray[0] = component;
                        return Boolean.FALSE;
                    }
                    return CONTINUE_TRAVERSAL;
                }
            });
            if (returnValue == null) {
                this.stateless = Boolean.TRUE;
            } else if (returnValue instanceof Boolean) {
                this.stateless = (Boolean)returnValue;
            }
        }
        return this.stateless;
    }

    @Override
    public final void onRedirect() {
    }

    public final <C extends Form<?>> void removePersistedFormData(Class<C> formClass, final boolean disablePersistence) {
        if (!Form.class.isAssignableFrom(formClass)) {
            throw new WicketRuntimeException("Form class " + formClass.getName() + " is not a subclass of Form");
        }
        this.visitChildren(formClass, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                if (component instanceof Form) {
                    ((Form)component).removePersistentFormComponentValues(disablePersistence);
                }
                return CONTINUE_TRAVERSAL;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renderPage() {
        if (!this.isActionAuthorized(RENDER)) {
            if (log.isDebugEnabled()) {
                log.debug("Page not allowed to render: " + this);
            }
            throw new UnauthorizedActionException(this, Component.RENDER);
        }
        this.renderedComponents = null;
        if (Boolean.TRUE.equals(this.stateless)) {
            this.stateless = null;
        }
        this.setFormComponentValuesFromCookies();
        try {
            this.prepareForRender();
        }
        catch (RuntimeException e) {
            try {
                this.afterRender();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
        try {
            this.render(null);
        }
        finally {
            this.afterRender();
        }
        this.checkRendering(this);
        if (Application.get().getDebugSettings().getComponentUseCheck()) {
            this.visitChildren(new Component.IVisitor<Component>(){

                @Override
                public Object component(Component component) {
                    component.setMetaData(Component.CONSTRUCTED_AT_KEY, null);
                    component.setMetaData(Component.ADDED_AT_KEY, null);
                    return CONTINUE_TRAVERSAL;
                }
            });
        }
        if (!this.isPageStateless()) {
            Session.get().getSessionStore().getSessionId(RequestCycle.get().getRequest(), true);
            this.getSession().touch(this);
        }
        if (this.getApplication().getDebugSettings().isOutputMarkupContainerClassName()) {
            Class<?> klass = this.getClass();
            while (klass.isAnonymousClass()) {
                klass = klass.getSuperclass();
            }
            this.getResponse().write("<!-- Page Class ");
            this.getResponse().write(klass.getName());
            this.getResponse().write(" -->\n");
        }
    }

    public final Page rollbackPage(int numberOfVersions) {
        Page page = this;
        if (this.versionManager != null) {
            page = this.versionManager.rollbackPage(numberOfVersions);
        }
        this.getSession().touch(page);
        return page;
    }

    @Override
    public final void setNumericId(int id) {
        this.numericId = id;
    }

    public final void setStatelessHint(boolean value) {
        if (value && !this.isBookmarkable()) {
            throw new WicketRuntimeException("Can't set stateless hint to true on a page when the page is not bookmarkable, page: " + this);
        }
        this.setFlag(65536, value);
    }

    public final void startComponentRender(Component component) {
        this.renderedComponents = null;
    }

    @Override
    public String toString() {
        if (this.versionManager != null) {
            return "[Page class = " + this.getClass().getName() + ", id = " + this.getId() + ", version = " + this.versionManager.getCurrentVersionNumber() + ", ajax = " + this.versionManager.getAjaxVersionNumber() + "]";
        }
        return "[Page class = " + this.getClass().getName() + ", id = " + this.getId() + ", version = " + 0 + "]";
    }

    private final void checkRendering(MarkupContainer renderedContainer) {
        IDebugSettings debugSettings = Application.get().getDebugSettings();
        if (debugSettings.getComponentUseCheck() && !this.getResponse().isRedirect()) {
            final ArrayList unrenderedComponents = new ArrayList();
            final StringBuffer buffer = new StringBuffer();
            renderedContainer.visitChildren(new Component.IVisitor<Component>(){

                @Override
                public Object component(Component component) {
                    if (Page.this.renderedComponents == null || !Page.this.renderedComponents.contains(component)) {
                        if (!component.isAuto() && component.isVisibleInHierarchy()) {
                            unrenderedComponents.add(component);
                            buffer.append(Integer.toString(unrenderedComponents.size()) + ". " + component + "\n");
                            String metadata = component.getMetaData(Component.CONSTRUCTED_AT_KEY);
                            if (metadata != null) {
                                buffer.append(metadata);
                            }
                            if ((metadata = component.getMetaData(Component.ADDED_AT_KEY)) != null) {
                                buffer.append(metadata);
                            }
                        } else {
                            return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                        }
                    }
                    return CONTINUE_TRAVERSAL;
                }
            });
            if (unrenderedComponents.size() > 0) {
                this.renderedComponents = null;
                ArrayList<Component> transparentContainerChildren = new ArrayList<Component>();
                Iterator iterator = unrenderedComponents.iterator();
                block0: while (iterator.hasNext()) {
                    Component component = (Component)iterator.next();
                    for (Component transparentContainerChild : transparentContainerChildren) {
                        for (MarkupContainer parent = component.getParent(); parent != null; parent = parent.getParent()) {
                            if (parent != transparentContainerChild) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                    Iterator<? extends Component> iterator2 = component.getParent().iterator();
                    while (iterator2.hasNext()) {
                        Component sibling = iterator2.next();
                        if (sibling.isVisible()) continue;
                        boolean isTransparentMarkupContainer = sibling instanceof MarkupContainer && ((MarkupContainer)sibling).isTransparentResolver();
                        boolean isComponentResolver = sibling instanceof IComponentResolver;
                        if (!isTransparentMarkupContainer && !isComponentResolver) continue;
                        log.debug("Component {} wasn't rendered but most likely it has a transparent parent: {}", (Object)component, (Object)sibling);
                        transparentContainerChildren.add(component);
                        iterator.remove();
                        continue block0;
                    }
                    Border border = component.findParent(Border.class);
                    if (border == null || border.getBodyContainer().isVisibleInHierarchy()) continue;
                    iterator.remove();
                }
                if (unrenderedComponents.size() > 0) {
                    throw new WicketRuntimeException("The component(s) below failed to render. A common problem is that you have added a component in code but forgot to reference it in the markup (thus the component will never be rendered).\n\n" + buffer.toString());
                }
            }
        }
        this.renderedComponents = null;
    }

    private final void endVersion() {
        this.setFlag((short)2048, true);
        if (this.getFlag((short)1024)) {
            this.setFlag((short)1024, false);
            if (this.versionManager != null) {
                this.versionManager.endVersion(this.getRequest().mergeVersion());
            }
            this.getApplication().getSessionSettings().getPageMapEvictionStrategy().evict(this.getPageMap());
        }
    }

    private final void init() {
        RequestCycle cycle = this.getRequestCycle();
        String pageMapName = null;
        if (cycle != null) {
            RequestParameters parameters = this.getRequest().getRequestParameters();
            pageMapName = parameters.getPageMapName();
        }
        IPageMap pageMap = PageMap.forName(pageMapName);
        this.init(pageMap);
    }

    private final void init(IPageMap pageMap) {
        if (this.isBookmarkable()) {
            this.setStatelessHint(true);
        }
        if (pageMap == null) {
            throw new IllegalStateException("PageMap cannot be null");
        }
        this.setPageMap(pageMap);
        this.setNextAvailableId();
        this.setVersioned(Application.get().getPageSettings().getVersionPagesByDefault());
        this.dirty();
    }

    private void setNextAvailableId() {
        if (this.getApplication().getSessionSettings().isPageIdUniquePerSession()) {
            this.setNumericId(this.getSession().nextPageId());
        } else {
            this.setNumericId(this.getPageMap().nextId());
        }
    }

    private final boolean mayTrackChangesFor(Component component, MarkupContainer parent) {
        this.componentChanged(component, parent);
        if (component.isAuto() || parent == null && !component.isVersioned() || parent != null && !parent.isVersioned()) {
            return false;
        }
        if (this.getFlag((short)2048)) {
            if (!this.getFlag((short)1024)) {
                if (this.versionManager == null) {
                    this.versionManager = this.getSession().getSessionStore().newVersionManager(this);
                }
                this.versionManager.beginVersion(this.getRequest().mergeVersion());
                this.setFlag((short)1024, true);
            }
            return true;
        }
        return false;
    }

    protected void componentChanged(Component component, MarkupContainer parent) {
    }

    void readPageObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        short id = s.readShort();
        String name = (String)s.readObject();
        IPageSerializer ps = serializer.get();
        if (ps != null) {
            ps.deserializePage(id, name, this, s);
        } else {
            s.defaultReadObject();
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        IPageSerializer ps = serializer.get();
        if (ps != null) {
            return ps.getPageReplacementObject(this);
        }
        return this;
    }

    void writePageObject(ObjectOutputStream s) throws IOException {
        s.writeShort(this.numericId);
        s.writeObject(this.pageMapName);
        IPageSerializer ps = serializer.get();
        if (ps != null) {
            ps.serializePage(this, s);
        } else {
            s.defaultWriteObject();
        }
    }

    protected void configureResponse() {
        RequestCycle cycle = this.getRequestCycle();
        Application application = cycle.getApplication();
        Response response = cycle.getResponse();
        String encoding = application.getRequestCycleSettings().getResponseRequestEncoding();
        response.setContentType("text/" + this.getMarkupType() + "; charset=" + encoding);
        MarkupStream markupStream = this.findMarkupStream();
        if (markupStream != null && markupStream.getXmlDeclaration() != null && !application.getMarkupSettings().getStripXmlDeclarationFromOutput()) {
            String quoteChar = markupStream.getXmlDeclaration().indexOf(34) == -1 ? "'" : "\"";
            response.write("<?xml version=");
            response.write(quoteChar);
            response.write("1.0");
            response.write(quoteChar);
            response.write(" encoding=");
            response.write(quoteChar);
            response.write(encoding);
            response.write(quoteChar);
            response.write("?>");
        }
        response.setLocale(this.getSession().getLocale());
    }

    @Override
    protected final void internalOnModelChanged() {
        this.visitChildren(new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                if (component.sameInnermostModel(Page.this)) {
                    component.modelChanged();
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
    }

    protected final void moveToPageMap(IPageMap map) {
        this.setPageMap(map);
        this.setNextAvailableId();
    }

    @Deprecated
    protected final IPageVersionManager newVersionManager() {
        return null;
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        if (this.getSession().isTemporary() && !this.peekPageStateless()) {
            this.getSession().bind();
        }
    }

    @Override
    protected void onDetach() {
        if (log.isDebugEnabled()) {
            log.debug("ending request for page " + this + ", request " + this.getRequest());
        }
        this.endVersion();
        this.dirty();
        super.onDetach();
    }

    @Override
    protected void onRender(MarkupStream markupStream) {
        MarkupStream associatedMarkupStream = this.getAssociatedMarkupStream(true);
        this.setMarkupStream(associatedMarkupStream);
        this.configureResponse();
        this.renderAll(associatedMarkupStream);
    }

    final void componentAdded(Component component) {
        this.dirty();
        if (this.mayTrackChangesFor(component, component.getParent())) {
            this.versionManager.componentAdded(component);
        }
    }

    final void componentModelChanging(Component component) {
        this.dirty();
        if (this.mayTrackChangesFor(component, null) && !component.getFlag(4)) {
            this.versionManager.componentModelChanging(component);
        }
    }

    final void componentRemoved(Component component) {
        this.dirty();
        if (this.mayTrackChangesFor(component, component.getParent())) {
            this.versionManager.componentRemoved(component);
        }
    }

    final void componentStateChanging(Component component, Change change) {
        this.dirty();
        if (this.mayTrackChangesFor(component, null)) {
            this.versionManager.componentStateChanging(change);
        }
    }

    final void setFormComponentValuesFromCookies() {
        this.visitChildren(Form.class, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                ((Form)component).loadPersistentFormComponentValues();
                return CONTINUE_TRAVERSAL;
            }
        });
    }

    final void setPageMap(IPageMap pageMap) {
        this.pageMap = pageMap;
        this.pageMapName = pageMap.getName();
    }

    void setPageStateless(Boolean stateless) {
        this.stateless = stateless;
    }

    public void onPageAttached() {
    }

    @Override
    public String getMarkupType() {
        throw new UnsupportedOperationException("Page does not support markup. This error can happen if you have extended Page directly, instead extend WebPage");
    }

    @Deprecated
    public PageId getPageId() {
        this.setStatelessHint(false);
        return new PageId(this.pageMapName, this.numericId, this.getCurrentVersionNumber());
    }

    public PageReference getPageReference() {
        this.setStatelessHint(false);
        return new PageReference(this.pageMapName, this.numericId, this.getCurrentVersionNumber());
    }

    public static interface IPageSerializer {
        public void deserializePage(int var1, String var2, Page var3, ObjectInputStream var4) throws IOException, ClassNotFoundException;

        public void serializePage(Page var1, ObjectOutputStream var2) throws IOException;

        public Object getPageReplacementObject(Page var1);
    }
}

