/*
 * Decompiled with CFR 0.152.
 */
package winstone.ajp13;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneOutputStream;
import winstone.ajp13.Ajp13Listener;

public class Ajp13OutputStream
extends WinstoneOutputStream {
    byte CONTAINER_SEND_BODY_CHUNK = (byte)3;
    byte CONTAINER_SEND_HEADERS = (byte)4;
    byte CONTAINER_END_RESPONSE = (byte)5;
    static Map headerCodes = null;
    private String headerEncoding;

    public Ajp13OutputStream(OutputStream outStream, String headerEncoding) {
        super(outStream, false);
        this.headerEncoding = headerEncoding;
    }

    public void commit() throws IOException {
        int packetLength;
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13OutputStream.CommittedBytes", "" + this.bytesCommitted);
        this.buffer.flush();
        if (!this.committed) {
            this.owner.validateHeaders();
            this.committed = true;
            ByteArrayOutputStream headerArrayStream = new ByteArrayOutputStream();
            Iterator i = this.owner.getHeaders().iterator();
            while (i.hasNext()) {
                String header = (String)i.next();
                int colonPos = header.indexOf(58);
                if (colonPos == -1) {
                    throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13OutputStream.NoColonHeader", header));
                }
                String headerName = header.substring(0, colonPos).trim();
                String headerValue = header.substring(colonPos + 1).trim();
                byte[] headerCode = (byte[])headerCodes.get(headerName.toLowerCase());
                if (headerCode == null) {
                    headerArrayStream.write(this.getStringBlock(headerName));
                } else {
                    headerArrayStream.write(headerCode);
                }
                headerArrayStream.write(this.getStringBlock(headerValue));
            }
            i = this.owner.getCookies().iterator();
            while (i.hasNext()) {
                Cookie cookie = (Cookie)i.next();
                String cookieText = this.owner.writeCookie(cookie);
                int colonPos = cookieText.indexOf(58);
                if (colonPos == -1) {
                    throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13OutputStream.NoColonHeader", cookieText));
                }
                String headerName = cookieText.substring(0, colonPos).trim();
                String headerValue = cookieText.substring(colonPos + 1).trim();
                byte[] headerCode = (byte[])headerCodes.get(headerName.toLowerCase());
                if (headerCode == null) {
                    headerArrayStream.write(this.getStringBlock(headerName));
                } else {
                    headerArrayStream.write(headerCode);
                }
                headerArrayStream.write(this.getStringBlock(headerValue));
            }
            byte[] headerArray = headerArrayStream.toByteArray();
            byte[] headerPacket = new byte[12];
            headerPacket[0] = 65;
            headerPacket[1] = 66;
            Ajp13OutputStream.setIntBlock(headerArray.length + 8, headerPacket, 2);
            headerPacket[4] = this.CONTAINER_SEND_HEADERS;
            Ajp13OutputStream.setIntBlock(this.owner.getStatus(), headerPacket, 5);
            Ajp13OutputStream.setIntBlock(0, headerPacket, 7);
            headerPacket[9] = 0;
            Ajp13OutputStream.setIntBlock(this.owner.getHeaders().size() + this.owner.getCookies().size(), headerPacket, 10);
            this.outStream.write(headerPacket);
            this.outStream.write(headerArray);
        }
        byte[] bufferContents = this.buffer.toByteArray();
        for (int position = 0; position < bufferContents.length; position += packetLength) {
            packetLength = Math.min(bufferContents.length - position, 8184);
            byte[] responsePacket = new byte[packetLength + 8];
            responsePacket[0] = 65;
            responsePacket[1] = 66;
            Ajp13OutputStream.setIntBlock(packetLength + 4, responsePacket, 2);
            responsePacket[4] = this.CONTAINER_SEND_BODY_CHUNK;
            Ajp13OutputStream.setIntBlock(packetLength, responsePacket, 5);
            System.arraycopy(bufferContents, position, responsePacket, 7, packetLength);
            responsePacket[packetLength + 7] = 0;
            this.outStream.write(responsePacket);
        }
        this.buffer.reset();
        this.bufferPosition = 0;
    }

    public void finishResponse() throws IOException {
        byte[] endResponse = new byte[]{65, 66, 0, 2, this.CONTAINER_END_RESPONSE, 1};
        this.outStream.write(endResponse);
    }

    public byte[] getIntBlock(int integer) {
        byte hi = (byte)(0xFF & integer >> 8);
        byte lo = (byte)(0xFF & integer - (hi << 8));
        return new byte[]{hi, lo};
    }

    public static void setIntBlock(int integer, byte[] packet, int offset) {
        byte hi = (byte)(0xFF & integer >> 8);
        byte lo = (byte)(0xFF & integer - (hi << 8));
        packet[offset] = hi;
        packet[offset + 1] = lo;
    }

    public byte[] getStringBlock(String text) throws UnsupportedEncodingException {
        byte[] textBytes = text.getBytes(this.headerEncoding);
        byte[] outArray = new byte[textBytes.length + 3];
        System.arraycopy(this.getIntBlock(textBytes.length), 0, outArray, 0, 2);
        System.arraycopy(textBytes, 0, outArray, 2, textBytes.length);
        outArray[textBytes.length + 2] = 0;
        return outArray;
    }

    static {
        headerCodes = new Hashtable();
        headerCodes.put("content-type", new byte[]{-96, 1});
        headerCodes.put("content-language", new byte[]{-96, 2});
        headerCodes.put("content-length", new byte[]{-96, 3});
        headerCodes.put("date", new byte[]{-96, 4});
        headerCodes.put("last-modified", new byte[]{-96, 5});
        headerCodes.put("location", new byte[]{-96, 6});
        headerCodes.put("set-cookie", new byte[]{-96, 7});
        headerCodes.put("set-cookie2", new byte[]{-96, 8});
        headerCodes.put("servlet-engine", new byte[]{-96, 9});
        headerCodes.put("server", new byte[]{-96, 9});
        headerCodes.put("status", new byte[]{-96, 10});
        headerCodes.put("www-authenticate", new byte[]{-96, 11});
    }
}

