/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import winstone.AccessLogger;
import winstone.HostConfiguration;
import winstone.Launcher;
import winstone.Listener;
import winstone.Logger;
import winstone.ObjectPool;
import winstone.RequestDispatcher;
import winstone.WebAppConfiguration;
import winstone.WinstoneInputStream;
import winstone.WinstoneOutputStream;
import winstone.WinstoneRequest;
import winstone.WinstoneResponse;

public class RequestHandlerThread
implements Runnable {
    private Thread thread;
    private ObjectPool objectPool;
    private WinstoneInputStream inData;
    private WinstoneOutputStream outData;
    private WinstoneRequest req;
    private WinstoneResponse rsp;
    private Listener listener;
    private Socket socket;
    private String threadName;
    private long requestStartTime;
    private boolean simulateModUniqueId;
    private boolean saveSessions;

    public RequestHandlerThread(ObjectPool objectPool, int threadIndex, boolean simulateModUniqueId, boolean saveSessions) {
        this.objectPool = objectPool;
        this.simulateModUniqueId = simulateModUniqueId;
        this.saveSessions = saveSessions;
        this.threadName = Launcher.RESOURCES.getString("RequestHandlerThread.ThreadName", "" + threadIndex);
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean interrupted = false;
        while (!interrupted) {
            InputStream inSocket = null;
            OutputStream outSocket = null;
            boolean iAmFirst = true;
            try {
                inSocket = this.socket.getInputStream();
                outSocket = this.socket.getOutputStream();
                boolean continueFlag = true;
                while (continueFlag && !interrupted) {
                    try {
                        ClassLoader cl;
                        int n;
                        long requestId = System.currentTimeMillis();
                        this.listener.allocateRequestResponse(this.socket, inSocket, outSocket, this, iAmFirst);
                        if (this.req == null) {
                            this.listener.deallocateRequestResponse(this, this.req, this.rsp, this.inData, this.outData);
                            continue;
                        }
                        String servletURI = this.listener.parseURI(this, this.req, this.rsp, this.inData, this.socket, iAmFirst);
                        if (servletURI == null) {
                            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestHandlerThread.KeepAliveTimedOut", this.threadName);
                            this.listener.deallocateRequestResponse(this, this.req, this.rsp, this.inData, this.outData);
                            continueFlag = false;
                            continue;
                        }
                        if (this.simulateModUniqueId) {
                            this.req.setAttribute("UNIQUE_ID", "" + requestId);
                        }
                        long headerParseTime = this.getRequestProcessTime();
                        iAmFirst = false;
                        HostConfiguration hostConfig = this.req.getHostGroup().getHostByName(this.req.getServerName());
                        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestHandlerThread.StartRequest", new String[]{"" + requestId, hostConfig.getHostname()});
                        WebAppConfiguration webAppConfig = hostConfig.getWebAppByURI(servletURI);
                        if (webAppConfig == null) {
                            webAppConfig = hostConfig.getWebAppByURI("/");
                        }
                        if (webAppConfig == null) {
                            Logger.log(Logger.WARNING, Launcher.RESOURCES, "RequestHandlerThread.UnknownWebapp", new String[]{servletURI});
                            this.rsp.sendError(404, Launcher.RESOURCES.getString("RequestHandlerThread.UnknownWebappPage", servletURI));
                            this.rsp.flushBuffer();
                            this.req.discardRequestBody();
                            this.writeToAccessLog(servletURI, this.req, this.rsp, null);
                            continueFlag = this.listener.processKeepAlive(this.req, this.rsp, inSocket);
                            this.listener.deallocateRequestResponse(this, this.req, this.rsp, this.inData, this.outData);
                            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestHandlerThread.FinishRequest", "" + requestId);
                            Logger.log(Logger.SPEED, Launcher.RESOURCES, "RequestHandlerThread.RequestTime", new String[]{servletURI, "" + headerParseTime, "" + this.getRequestProcessTime()});
                            continue;
                        }
                        this.req.setWebAppConfig(webAppConfig);
                        ServletRequestListener[] reqLsnrs = webAppConfig.getRequestListeners();
                        for (n = 0; n < reqLsnrs.length; ++n) {
                            cl = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(webAppConfig.getLoader());
                            reqLsnrs[n].requestInitialized(new ServletRequestEvent(webAppConfig, this.req));
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        this.processRequest(webAppConfig, this.req, this.rsp, webAppConfig.getServletURIFromRequestURI(servletURI));
                        this.writeToAccessLog(servletURI, this.req, this.rsp, webAppConfig);
                        this.outData.finishResponse();
                        this.inData.finishRequest();
                        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestHandlerThread.FinishRequest", "" + requestId);
                        continueFlag = this.listener.processKeepAlive(this.req, this.rsp, inSocket);
                        this.req.markSessionsAsRequestFinished(this.requestStartTime, this.saveSessions);
                        for (n = 0; n < reqLsnrs.length; ++n) {
                            cl = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(webAppConfig.getLoader());
                            reqLsnrs[n].requestDestroyed(new ServletRequestEvent(webAppConfig, this.req));
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        this.req.setWebAppConfig(null);
                        this.rsp.setWebAppConfig(null);
                        this.req.setRequestAttributeListeners(null);
                        this.listener.deallocateRequestResponse(this, this.req, this.rsp, this.inData, this.outData);
                        Logger.log(Logger.SPEED, Launcher.RESOURCES, "RequestHandlerThread.RequestTime", new String[]{servletURI, "" + headerParseTime, "" + this.getRequestProcessTime()});
                    }
                    catch (InterruptedIOException errIO) {
                        continueFlag = false;
                        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestHandlerThread.SocketTimeout", errIO);
                    }
                    catch (SocketException errIO) {
                        continueFlag = false;
                    }
                }
                this.listener.deallocateRequestResponse(this, this.req, this.rsp, this.inData, this.outData);
                this.listener.releaseSocket(this.socket, inSocket, outSocket);
            }
            catch (Throwable err) {
                try {
                    this.listener.deallocateRequestResponse(this, this.req, this.rsp, this.inData, this.outData);
                }
                catch (Throwable errClose) {
                    // empty catch block
                }
                try {
                    this.listener.releaseSocket(this.socket, inSocket, outSocket);
                }
                catch (Throwable errClose) {
                    // empty catch block
                }
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "RequestHandlerThread.RequestError", err);
            }
            this.objectPool.releaseRequestHandler(this);
            if (interrupted) continue;
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestHandlerThread.EnterWaitState");
            try {
                RequestHandlerThread err = this;
                synchronized (err) {
                    this.wait();
                }
            }
            catch (InterruptedException err) {
                interrupted = true;
            }
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestHandlerThread.WakingUp");
        }
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestHandlerThread.ThreadExit");
    }

    private void processRequest(WebAppConfiguration webAppConfig, WinstoneRequest req, WinstoneResponse rsp, String path) throws IOException, ServletException {
        RequestDispatcher rd = null;
        RequestDispatcher rdError = null;
        try {
            rd = webAppConfig.getInitialDispatcher(path, req, rsp);
            if (rd != null) {
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "RequestHandlerThread.HandlingRD", rd.getName());
                rd.forward(req, rsp);
            }
        }
        catch (Throwable err) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "RequestHandlerThread.UntrappedError", err);
            rdError = webAppConfig.getErrorDispatcherByClass(err);
        }
        if (rdError != null) {
            try {
                if (rsp.isCommitted()) {
                    rdError.include(req, rsp);
                } else {
                    rsp.resetBuffer();
                    rdError.forward(req, rsp);
                }
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "RequestHandlerThread.ErrorInErrorServlet", err);
            }
        }
        rsp.flushBuffer();
        rsp.getWinstoneOutputStream().setClosed(true);
        req.discardRequestBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commenceRequestHandling(Socket socket, Listener listener) {
        this.listener = listener;
        this.socket = socket;
        if (this.thread.isAlive()) {
            RequestHandlerThread requestHandlerThread = this;
            synchronized (requestHandlerThread) {
                this.notifyAll();
            }
        } else {
            this.thread.start();
        }
    }

    public void setRequest(WinstoneRequest request) {
        this.req = request;
    }

    public void setResponse(WinstoneResponse response) {
        this.rsp = response;
    }

    public void setInStream(WinstoneInputStream inStream) {
        this.inData = inStream;
    }

    public void setOutStream(WinstoneOutputStream outStream) {
        this.outData = outStream;
    }

    public void setRequestStartTime() {
        this.requestStartTime = System.currentTimeMillis();
    }

    public long getRequestProcessTime() {
        return System.currentTimeMillis() - this.requestStartTime;
    }

    public void destroy() {
        if (this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    protected void writeToAccessLog(String originalURL, WinstoneRequest request, WinstoneResponse response, WebAppConfiguration webAppConfig) {
        AccessLogger logger;
        if (webAppConfig != null && (logger = webAppConfig.getAccessLogger()) != null) {
            logger.log(originalURL, request, response);
        }
    }
}

