/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import winstone.Cluster;
import winstone.HostConfiguration;
import winstone.HostGroup;
import winstone.JNDIManager;
import winstone.Listener;
import winstone.Logger;
import winstone.ObjectPool;
import winstone.ShutdownHook;
import winstone.WebAppConfiguration;
import winstone.WinstoneResourceBundle;

public class Launcher
implements Runnable {
    static final String HTTP_LISTENER_CLASS = "winstone.HttpListener";
    static final String HTTPS_LISTENER_CLASS = "winstone.ssl.HttpsListener";
    static final String AJP_LISTENER_CLASS = "winstone.ajp13.Ajp13Listener";
    static final String CLUSTER_CLASS = "winstone.cluster.SimpleCluster";
    static final String DEFAULT_JNDI_MGR_CLASS = "winstone.jndi.ContainerJNDIManager";
    public static final byte SHUTDOWN_TYPE = 48;
    public static final byte RELOAD_TYPE = 52;
    private int CONTROL_TIMEOUT = 2000;
    private int DEFAULT_CONTROL_PORT = -1;
    private Thread controlThread;
    public static final WinstoneResourceBundle RESOURCES = new WinstoneResourceBundle("winstone.LocalStrings");
    private int controlPort;
    private HostGroup hostGroup;
    private ObjectPool objectPool;
    private List listeners;
    private Map args;
    private Cluster cluster;
    private JNDIManager globalJndiManager;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$winstone$ObjectPool;
    static /* synthetic */ Class class$winstone$HostGroup;
    static /* synthetic */ Class class$winstone$Launcher;

    public Launcher(Map args) throws IOException {
        boolean switchOnCluster;
        boolean useJNDI = WebAppConfiguration.booleanArg(args, "useJNDI", false);
        if (useJNDI) {
            try {
                Class<?> ctxFactoryClass = Class.forName("winstone.jndi.java.javaURLContextFactory");
                if (System.getProperty("java.naming.factory.initial") == null) {
                    System.setProperty("java.naming.factory.initial", ctxFactoryClass.getName());
                }
                if (System.getProperty("java.naming.factory.url.pkgs") == null) {
                    System.setProperty("java.naming.factory.url.pkgs", "winstone.jndi");
                }
            }
            catch (ClassNotFoundException err) {
                // empty catch block
            }
        }
        Logger.log(Logger.MAX, RESOURCES, "Launcher.StartupArgs", args + "");
        this.args = args;
        this.controlPort = args.get("controlPort") == null ? this.DEFAULT_CONTROL_PORT : Integer.parseInt((String)args.get("controlPort"));
        ArrayList<URL> jars = new ArrayList<URL>();
        ArrayList<File> commonLibCLPaths = new ArrayList<File>();
        String defaultJavaHome = System.getProperty("java.home");
        String javaHome = WebAppConfiguration.stringArg(args, "javaHome", defaultJavaHome);
        Logger.log(Logger.DEBUG, RESOURCES, "Launcher.UsingJavaHome", javaHome);
        String toolsJarLocation = WebAppConfiguration.stringArg(args, "toolsJar", null);
        File toolsJar = null;
        if (toolsJarLocation == null) {
            File javaHome2;
            File toolsJar2;
            toolsJar = new File(javaHome, "lib/tools.jar");
            if (!toolsJar.exists() && (toolsJar2 = new File(javaHome2 = new File(javaHome).getParentFile(), "lib/tools.jar")).exists()) {
                javaHome = javaHome2.getCanonicalPath();
                toolsJar = toolsJar2;
            }
        } else {
            toolsJar = new File(toolsJarLocation);
        }
        if (toolsJar.exists()) {
            jars.add(toolsJar.toURL());
            commonLibCLPaths.add(toolsJar);
            Logger.log(Logger.DEBUG, RESOURCES, "Launcher.AddedCommonLibJar", toolsJar.getName());
        } else if (WebAppConfiguration.booleanArg(args, "useJasper", false)) {
            Logger.log(Logger.WARNING, RESOURCES, "Launcher.ToolsJarNotFound");
        }
        String commonLibCLFolder = WebAppConfiguration.stringArg(args, "commonLibFolder", "lib");
        File libFolder = new File(commonLibCLFolder);
        if (libFolder.exists() && libFolder.isDirectory()) {
            Logger.log(Logger.DEBUG, RESOURCES, "Launcher.UsingCommonLib", libFolder.getCanonicalPath());
            File[] children = libFolder.listFiles();
            for (int n = 0; n < children.length; ++n) {
                if (!children[n].getName().endsWith(".jar") && !children[n].getName().endsWith(".zip")) continue;
                jars.add(children[n].toURL());
                commonLibCLPaths.add(children[n]);
                Logger.log(Logger.DEBUG, RESOURCES, "Launcher.AddedCommonLibJar", children[n].getName());
            }
        } else {
            Logger.log(Logger.DEBUG, RESOURCES, "Launcher.NoCommonLib");
        }
        URLClassLoader commonLibCL = new URLClassLoader(jars.toArray(new URL[jars.size()]), this.getClass().getClassLoader());
        Logger.log(Logger.MAX, RESOURCES, "Launcher.CLClassLoader", commonLibCL.toString());
        Logger.log(Logger.MAX, RESOURCES, "Launcher.CLClassLoader", ((Object)commonLibCLPaths).toString());
        this.objectPool = new ObjectPool(args);
        String useCluster = (String)args.get("useCluster");
        boolean bl = switchOnCluster = useCluster != null && (useCluster.equalsIgnoreCase("true") || useCluster.equalsIgnoreCase("yes"));
        if (switchOnCluster) {
            if (this.controlPort < 0) {
                Logger.log(Logger.INFO, RESOURCES, "Launcher.ClusterOffNoControlPort");
            } else {
                String clusterClassName = WebAppConfiguration.stringArg(args, "clusterClassName", CLUSTER_CLASS).trim();
                try {
                    Class<?> clusterClass = Class.forName(clusterClassName);
                    Constructor<?> clusterConstructor = clusterClass.getConstructor(class$java$util$Map == null ? (class$java$util$Map = Launcher.class$("java.util.Map")) : class$java$util$Map, class$java$lang$Integer == null ? (class$java$lang$Integer = Launcher.class$("java.lang.Integer")) : class$java$lang$Integer);
                    this.cluster = (Cluster)clusterConstructor.newInstance(args, new Integer(this.controlPort));
                }
                catch (ClassNotFoundException err) {
                    Logger.log(Logger.DEBUG, RESOURCES, "Launcher.ClusterNotFound");
                }
                catch (Throwable err) {
                    Logger.log(Logger.WARNING, RESOURCES, "Launcher.ClusterStartupError", err);
                }
            }
        }
        if (useJNDI) {
            String jndiMgrClassName = WebAppConfiguration.stringArg(args, "containerJndiClassName", DEFAULT_JNDI_MGR_CLASS).trim();
            try {
                Class<?> jndiMgrClass = Class.forName(jndiMgrClassName, true, commonLibCL);
                Constructor<?> jndiMgrConstr = jndiMgrClass.getConstructor(class$java$util$Map == null ? (class$java$util$Map = Launcher.class$("java.util.Map")) : class$java$util$Map, class$java$util$List == null ? (class$java$util$List = Launcher.class$("java.util.List")) : class$java$util$List, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Launcher.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                this.globalJndiManager = (JNDIManager)jndiMgrConstr.newInstance(args, null, commonLibCL);
                this.globalJndiManager.setup();
            }
            catch (ClassNotFoundException err) {
                Logger.log(Logger.DEBUG, RESOURCES, "Launcher.JNDIDisabled");
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, RESOURCES, "Launcher.JNDIError", jndiMgrClassName, err);
            }
        }
        this.hostGroup = new HostGroup(this.cluster, this.objectPool, commonLibCL, commonLibCLPaths.toArray(new File[0]), args);
        this.listeners = new ArrayList();
        this.spawnListener(HTTP_LISTENER_CLASS);
        this.spawnListener(AJP_LISTENER_CLASS);
        try {
            Class.forName("javax.net.ServerSocketFactory");
            this.spawnListener(HTTPS_LISTENER_CLASS);
        }
        catch (ClassNotFoundException err) {
            Logger.log(Logger.DEBUG, RESOURCES, "Launcher.NeedsJDK14", HTTPS_LISTENER_CLASS);
        }
        this.controlThread = new Thread((Runnable)this, RESOURCES.getString("Launcher.ThreadName", "" + this.controlPort));
        this.controlThread.setDaemon(false);
        this.controlThread.start();
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this));
    }

    protected void spawnListener(String listenerClassName) {
        try {
            Class<?> listenerClass = Class.forName(listenerClassName);
            Constructor<?> listenerConstructor = listenerClass.getConstructor(class$java$util$Map == null ? (class$java$util$Map = Launcher.class$("java.util.Map")) : class$java$util$Map, class$winstone$ObjectPool == null ? (class$winstone$ObjectPool = Launcher.class$("winstone.ObjectPool")) : class$winstone$ObjectPool, class$winstone$HostGroup == null ? (class$winstone$HostGroup = Launcher.class$("winstone.HostGroup")) : class$winstone$HostGroup);
            Listener listener = (Listener)listenerConstructor.newInstance(this.args, this.objectPool, this.hostGroup);
            if (listener.start()) {
                this.listeners.add(listener);
            }
        }
        catch (ClassNotFoundException err) {
            Logger.log(Logger.INFO, RESOURCES, "Launcher.ListenerNotFound", listenerClassName);
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, RESOURCES, "Launcher.ListenerStartupError", listenerClassName, err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        boolean interrupted = false;
        try {
            ServerSocket controlSocket = null;
            if (this.controlPort > 0) {
                controlSocket = new ServerSocket(this.controlPort);
                controlSocket.setSoTimeout(this.CONTROL_TIMEOUT);
            }
            Logger.log(Logger.INFO, RESOURCES, "Launcher.StartupOK", new String[]{RESOURCES.getString("ServerVersion"), this.controlPort > 0 ? "" + this.controlPort : RESOURCES.getString("Launcher.ControlDisabled")});
            while (!interrupted) {
                IOException err2222;
                Object var6_9;
                Socket accepted;
                block25: {
                    block24: {
                        accepted = null;
                        if (controlSocket != null) {
                            accepted = controlSocket.accept();
                            if (accepted != null) {
                                this.handleControlRequest(accepted);
                            }
                            break block24;
                        }
                        Thread.sleep(this.CONTROL_TIMEOUT);
                    }
                    var6_9 = null;
                    if (accepted == null) break block25;
                    try {
                        accepted.close();
                    }
                    catch (IOException err2222) {
                        // empty catch block
                    }
                }
                if (!Thread.interrupted()) continue;
                interrupted = true;
                {
                    continue;
                    catch (InterruptedIOException err3) {
                        var6_9 = null;
                        if (accepted != null) {
                            try {
                                accepted.close();
                            }
                            catch (IOException err2222) {
                                // empty catch block
                            }
                        }
                        if (!Thread.interrupted()) continue;
                        interrupted = true;
                        continue;
                    }
                    catch (InterruptedException err4) {
                        interrupted = true;
                        var6_9 = null;
                        if (accepted != null) {
                            try {
                                accepted.close();
                            }
                            catch (IOException err2222) {
                                // empty catch block
                            }
                        }
                        if (!Thread.interrupted()) continue;
                        interrupted = true;
                        continue;
                    }
                    catch (Throwable err5) {
                        Logger.log(Logger.ERROR, RESOURCES, "Launcher.ShutdownError", err5);
                        var6_9 = null;
                        if (accepted != null) {
                            try {
                                accepted.close();
                            }
                            catch (IOException err2222) {
                                // empty catch block
                            }
                        }
                        if (!Thread.interrupted()) continue;
                        interrupted = true;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var6_9 = null;
                    if (accepted != null) {
                        try {
                            accepted.close();
                        }
                        catch (IOException err2222) {
                            // empty catch block
                        }
                    }
                    if (Thread.interrupted()) {
                        interrupted = true;
                    }
                    throw throwable;
                }
            }
            if (controlSocket != null) {
                controlSocket.close();
            }
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, RESOURCES, "Launcher.ShutdownError", err);
        }
        Logger.log(Logger.INFO, RESOURCES, "Launcher.ControlThreadShutdownOK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleControlRequest(Socket csAccepted) throws IOException {
        IOException err22;
        OutputStream outSocket;
        InputStream inSocket;
        block21: {
            inSocket = null;
            outSocket = null;
            ObjectInputStream inControl = null;
            try {
                inSocket = csAccepted.getInputStream();
                int reqType = inSocket.read();
                if ((byte)reqType == 48) {
                    Logger.log(Logger.INFO, RESOURCES, "Launcher.ShutdownRequestReceived");
                    this.shutdown();
                } else if ((byte)reqType == 52) {
                    inControl = new ObjectInputStream(inSocket);
                    String host = inControl.readUTF();
                    String prefix = inControl.readUTF();
                    Logger.log(Logger.INFO, RESOURCES, "Launcher.ReloadRequestReceived", host + prefix);
                    HostConfiguration hostConfig = this.hostGroup.getHostByName(host);
                    hostConfig.reloadWebApp(prefix);
                } else if (this.cluster != null) {
                    outSocket = csAccepted.getOutputStream();
                    this.cluster.clusterRequest((byte)reqType, inSocket, outSocket, csAccepted, this.hostGroup);
                }
                Object var10_9 = null;
                if (inControl == null) break block21;
            }
            catch (Throwable throwable) {
                IOException err22;
                Object var10_10 = null;
                if (inControl != null) {
                    try {
                        inControl.close();
                    }
                    catch (IOException err22) {
                        // empty catch block
                    }
                }
                if (inSocket != null) {
                    try {
                        inSocket.close();
                    }
                    catch (IOException err22) {
                        // empty catch block
                    }
                }
                if (outSocket != null) {
                    try {
                        outSocket.close();
                    }
                    catch (IOException err22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                inControl.close();
            }
            catch (IOException err22) {
                // empty catch block
            }
        }
        if (inSocket != null) {
            try {
                inSocket.close();
            }
            catch (IOException err22) {
                // empty catch block
            }
        }
        if (outSocket != null) {
            try {
                outSocket.close();
            }
            catch (IOException err22) {}
        }
    }

    public void shutdown() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((Listener)i.next()).destroy();
        }
        this.objectPool.destroy();
        if (this.cluster != null) {
            this.cluster.destroy();
        }
        this.hostGroup.destroy();
        if (this.globalJndiManager != null) {
            this.globalJndiManager.tearDown();
        }
        if (this.controlThread != null) {
            this.controlThread.interrupt();
        }
        Thread.yield();
        Logger.log(Logger.INFO, RESOURCES, "Launcher.ShutdownOK");
    }

    public boolean isRunning() {
        return this.controlThread != null && this.controlThread.isAlive();
    }

    public static void main(String[] argv) throws IOException {
        Map args = Launcher.getArgsFromCommandLine(argv);
        if (args.containsKey("usage") || args.containsKey("help")) {
            Launcher.printUsage();
            return;
        }
        Launcher.deployEmbeddedWarfile(args);
        if (!(args.containsKey("webroot") || args.containsKey("warfile") || args.containsKey("webappsDir") || args.containsKey("hostsDir"))) {
            Launcher.printUsage();
            return;
        }
        try {
            new Launcher(args);
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, RESOURCES, "Launcher.ContainerStartupError", err);
        }
    }

    public static Map getArgsFromCommandLine(String[] argv) throws IOException {
        File webapp;
        Map args = Launcher.loadArgsFromCommandLineAndConfig(argv, "nonSwitch");
        String firstNonSwitchArgument = (String)args.get("nonSwitch");
        args.remove("nonSwitch");
        if (firstNonSwitchArgument != null && (webapp = new File(firstNonSwitchArgument)).exists()) {
            if (webapp.isDirectory()) {
                args.put("webroot", firstNonSwitchArgument);
            } else if (webapp.isFile()) {
                args.put("warfile", firstNonSwitchArgument);
            }
        }
        return args;
    }

    public static Map loadArgsFromCommandLineAndConfig(String[] argv, String nonSwitchArgName) throws IOException {
        String embeddedPropertiesFilename;
        HashMap<String, String> args = new HashMap<String, String>();
        InputStream embeddedPropsStream = (class$winstone$Launcher == null ? (class$winstone$Launcher = Launcher.class$("winstone.Launcher")) : class$winstone$Launcher).getResourceAsStream(embeddedPropertiesFilename = RESOURCES.getString("Launcher.EmbeddedPropertiesFile"));
        if (embeddedPropsStream != null) {
            Launcher.loadPropsFromStream(embeddedPropsStream, args);
            embeddedPropsStream.close();
        }
        String configFilename = RESOURCES.getString("Launcher.DefaultPropertyFile");
        for (int n = 0; n < argv.length; ++n) {
            String option = argv[n];
            if (option.startsWith("--")) {
                int equalPos = option.indexOf(61);
                String paramName = option.substring(2, equalPos == -1 ? option.length() : equalPos);
                if (equalPos != -1) {
                    args.put(paramName, option.substring(equalPos + 1));
                } else {
                    args.put(paramName, "true");
                }
                if (!paramName.equals("config")) continue;
                configFilename = (String)args.get(paramName);
                continue;
            }
            args.put(nonSwitchArgName, option);
        }
        File configFile = new File(configFilename);
        if (configFile.exists() && configFile.isFile()) {
            FileInputStream inConfig = new FileInputStream(configFile);
            Launcher.loadPropsFromStream(inConfig, args);
            ((InputStream)inConfig).close();
            Launcher.initLogger(args);
            Logger.log(Logger.DEBUG, RESOURCES, "Launcher.UsingPropertyFile", configFilename);
        } else {
            Launcher.initLogger(args);
        }
        return args;
    }

    protected static void deployEmbeddedWarfile(Map args) throws IOException {
        String embeddedWarfileName;
        InputStream embeddedWarfile = (class$winstone$Launcher == null ? (class$winstone$Launcher = Launcher.class$("winstone.Launcher")) : class$winstone$Launcher).getResourceAsStream(embeddedWarfileName = RESOURCES.getString("Launcher.EmbeddedWarFile"));
        if (embeddedWarfile != null) {
            File tempWarfile = File.createTempFile("embedded", ".war").getAbsoluteFile();
            tempWarfile.getParentFile().mkdirs();
            tempWarfile.deleteOnExit();
            String embeddedWebroot = RESOURCES.getString("Launcher.EmbeddedWebroot");
            File tempWebroot = new File(tempWarfile.getParentFile(), embeddedWebroot);
            tempWebroot.mkdirs();
            Logger.log(Logger.DEBUG, RESOURCES, "Launcher.CopyingEmbeddedWarfile", tempWarfile.getAbsolutePath());
            FileOutputStream out = new FileOutputStream(tempWarfile, true);
            int read = 0;
            byte[] buffer = new byte[2048];
            while ((read = embeddedWarfile.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            ((OutputStream)out).close();
            embeddedWarfile.close();
            args.put("warfile", tempWarfile.getAbsolutePath());
            args.put("webroot", tempWebroot.getAbsolutePath());
            args.remove("webappsDir");
            args.remove("hostsDir");
        }
    }

    protected static void loadPropsFromStream(InputStream inConfig, Map args) throws IOException {
        Properties props = new Properties();
        props.load(inConfig);
        Iterator i = ((Hashtable)props).keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (args.containsKey(key.trim())) continue;
            args.put(key.trim(), props.getProperty(key).trim());
        }
        ((Hashtable)props).clear();
    }

    public static void initLogger(Map args) throws IOException {
        int logLevel = WebAppConfiguration.intArg(args, "debug", Logger.INFO);
        boolean showThrowingThread = WebAppConfiguration.booleanArg(args, "logThrowingThread", false);
        OutputStream logStream = null;
        logStream = args.get("logfile") != null ? new FileOutputStream((String)args.get("logfile")) : (WebAppConfiguration.booleanArg(args, "logToStdErr", false) ? System.err : System.out);
        Logger.init(logLevel, logStream, showThrowingThread);
    }

    protected static void printUsage() {
        System.out.println(RESOURCES.getString("Launcher.UsageInstructions", RESOURCES.getString("ServerVersion")));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

