/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.guice;

import com.google.inject.BindingAnnotation;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.guice.GuiceInjectorHolder;
import org.apache.wicket.guice.GuiceProxyTargetLocator;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;

public class GuiceComponentInjector
implements IComponentInstantiationListener {
    public GuiceComponentInjector(Application app) {
        this(app, new Module[0]);
    }

    public GuiceComponentInjector(Application app, Module ... modules) {
        this(app, Guice.createInjector((Stage)(app.getConfigurationType().equals("development") ? Stage.DEVELOPMENT : Stage.PRODUCTION), (Module[])modules));
    }

    public GuiceComponentInjector(Application app, Injector injector) {
        app.setMetaData(GuiceInjectorHolder.INJECTOR_KEY, (Object)new GuiceInjectorHolder(injector));
    }

    public void inject(Object object) {
        Class<?> current = object.getClass();
        do {
            Method[] currentMethods;
            Field[] currentFields;
            for (Field field : currentFields = current.getDeclaredFields()) {
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (Modifier.isStatic(field.getModifiers()) || injectAnnotation == null) continue;
                try {
                    Annotation bindingAnnotation = GuiceComponentInjector.findBindingAnnotation(field.getAnnotations());
                    Object proxy = LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)new GuiceProxyTargetLocator(field, bindingAnnotation, injectAnnotation.optional()));
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(object, proxy);
                }
                catch (IllegalAccessException e) {
                    throw new WicketRuntimeException("Error Guice-injecting field " + field.getName() + " in " + object, (Throwable)e);
                }
                catch (MoreThanOneBindingException e) {
                    throw new RuntimeException("Can't have more than one BindingAnnotation on field " + field.getName() + " of class " + object.getClass().getName());
                }
            }
            for (Method method : currentMethods = current.getDeclaredMethods()) {
                Inject injectAnnotation = method.getAnnotation(Inject.class);
                if (Modifier.isStatic(method.getModifiers()) || injectAnnotation == null) continue;
                Annotation[][] paramAnnotations = method.getParameterAnnotations();
                Class<?>[] paramTypes = method.getParameterTypes();
                Type[] genericParamTypes = method.getGenericParameterTypes();
                Object[] args = new Object[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    Type paramType = genericParamTypes[i] instanceof ParameterizedType ? ((ParameterizedType)genericParamTypes[i]).getRawType() : paramTypes[i];
                    try {
                        Annotation bindingAnnotation = GuiceComponentInjector.findBindingAnnotation(paramAnnotations[i]);
                        args[i] = LazyInitProxyFactory.createProxy(paramTypes[i], (IProxyTargetLocator)new GuiceProxyTargetLocator(method, i, bindingAnnotation, injectAnnotation.optional()));
                        continue;
                    }
                    catch (MoreThanOneBindingException e) {
                        throw new RuntimeException("Can't have more than one BindingAnnotation on parameter " + i + "(" + paramType + ") of method " + method.getName() + " of class " + object.getClass().getName());
                    }
                }
                try {
                    method.invoke(object, args);
                }
                catch (IllegalAccessException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        } while ((current = current.getSuperclass()) != null && current != Object.class);
    }

    public void onInstantiation(Component component) {
        this.inject(component);
    }

    public static Annotation findBindingAnnotation(Annotation[] annotations) throws MoreThanOneBindingException {
        Annotation bindingAnnotation = null;
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getAnnotation(BindingAnnotation.class) == null) continue;
            if (bindingAnnotation != null) {
                throw new MoreThanOneBindingException();
            }
            bindingAnnotation = annotation;
        }
        return bindingAnnotation;
    }

    public static class MoreThanOneBindingException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

