//############################################################################//  
//Made in 2005-2013 by Artyom Litvinovich
//oshdll structures
//############################################################################// 
unit os_var;
interface 
uses sysutils;
//############################################################################//
const
MFD_LEFT= 0;
MFD_RIGHT=1;
MFD_USER1=2;
MFD_USER2=3;
MFD_USER3=4;
MFD_USER4=5;
MFD_USER5=6;
MFD_USER6=7;
MFD_USER7=8;
MFD_USER8=9;

BEACONSHAPE_COMPACT=0;
BEACONSHAPE_DIFFUSE=1;
BEACONSHAPE_STAR   =2;    
 
VFERR_OK=0;

//Framework dump to prevent 5+ extra files of irrelevant stuff
type    
dword=cardinal;  
dworda=array[0..maxint div 4-1]of dword;
pdworda=^dworda;
dwordap=array[0..maxint div 4-1]of pdworda;
ppdworda=^dwordap;  

worda=array[0..maxint div 2-1]of word;
pworda=^worda;  

chara=array[0..maxint-1]of char;
pchara=^chara; 

bytea=array[0..maxint-1]of byte;
pbytea=^bytea;  

crgba=array[0..3]of byte;
pcrgba=^crgba;     
                
vfile=file;

vec=record x,y,z:double;end;
pvec=^vec;

const
zvec:vec=(x:0;y:0;z:0);
evec:vec=(x:1;y:1;z:1);

//Config block
type
oshdll_config=record
 id:dword;
 vesnam,dllnam:array[0..254]of char;
 size,mass:double;
 pmi,cross,rdrag:vec;
 tdp_anim:integer;
 defcamera:vec;
 frc1,frc2,cw1,cw2,cw3,cw4,pitchms,bankms:double;
 transponder,navrcnt,use_pm,sorted_anims,needs_pilot:integer;  
 time_spent:double; 
 
 albedo:crgba;
 gravgrad,wingasp,wingeff,maxbrakef,vislim1,vislim2:double; 
 vcon:integer;

 propcnt:integer;
 thcnt,thgcnt:integer;
 exhcnt:integer;
 mshcnt:integer;
 anicnt:integer;
 vccnt:integer;
 tdcnt:integer;
 beaccnt:integer;
 dockcnt:integer;
 crewcnt:integer;
 aircnt:integer;
 attcnt:integer;
 armcnt:integer;  
 paycnt:integer;
end;
poshdll_config=^oshdll_config;
oshdll_propinfo=record
 mass:double;
end;     
aoshdll_propinfo=array[0..10000]of oshdll_propinfo;
paoshdll_propinfo=^aoshdll_propinfo;
oshdll_thinfo=record
 pos,dir:vec;
 maxthr,isp,ispref,pref:double;
 phid:integer;
 grp:array[0..7]of integer;
end;
poshdll_thinfo=^oshdll_thinfo;        
aoshdll_thinfo=array[0..10000]of oshdll_thinfo;
paoshdll_thinfo=^aoshdll_thinfo;
oshdll_exhinfo=record
 th,tex,tp:integer;
 lscl,wscl:double;
 pos,rot:vec;
end;    
aoshdll_exhinfo=array[0..10000]of oshdll_exhinfo;
paoshdll_exhinfo=^aoshdll_exhinfo;
oshdll_mshinfo=record
 nam:array[0..254]of char;
 typ:integer;
 id:dword;
 vis:integer;
 off:vec;
end;    
aoshdll_mshinfo=array[0..10000]of oshdll_mshinfo;
paoshdll_mshinfo=^aoshdll_mshinfo;
oshdll_animcompinfo=packed record
 msh,id,tp,grp,parent:integer;
 ref,axshsc:vec;
 angle:single;
 st0,st1:double;
 cmpdef:pointer;
 cmpt:pointer;
end;
aoshdll_animcompinfo=array[0..maxint div 100]of oshdll_animcompinfo;
paoshdll_animcompinfo=^aoshdll_animcompinfo;
oshdll_animinfo=packed record
 id,tp,rept,pause,trigkey:dword;
 status:integer;
 spd,proc,init:double;
 grpcnt,compcnt:integer;
 grp:ppdworda;
 comp:paoshdll_animcompinfo;
end;    
aoshdll_animinfo=array[0..10000]of oshdll_animinfo;
paoshdll_animinfo=^aoshdll_animinfo;

oshdll_vcmfdinfo=record
 nmesh,ngroup,tp:dword;
end;
aoshdll_vcmfdinfo=array[0..maxint div 100]of oshdll_vcmfdinfo;
paoshdll_vcmfdinfo=^aoshdll_vcmfdinfo;
oshdll_vcinfo=record
 camoff,camdir:vec;
 camrng:array[0..2]of vec;
 nbhs:array[0..3]of integer;
 
 hudmsh,hudgrp:integer;
 hudoff:vec;
 hudsiz:double;

 mfdcnt:integer; 
 mfds:paoshdll_vcmfdinfo; 
end;   
aoshdll_vcinfo=array[0..10000]of oshdll_vcinfo;
paoshdll_vcinfo=^aoshdll_vcinfo;   
oshdll_tdinfo=record
 pta,ptb,ptc:vec;
end; 
aoshdll_tdinfo=array[0..10000]of oshdll_tdinfo;
paoshdll_tdinfo=^aoshdll_tdinfo;
BEACONLIGHTSPEC=record
 shape:dword;
 pos,col:pvec;
 size,falloff,period,duration,tofs:double;
 active:boolean;
end;  
oshdll_beacinfo=packed record
 bl:BEACONLIGHTSPEC;
 pos,col:vec;
end;  
aoshdll_beacinfo=array[0..10000]of oshdll_beacinfo;
paoshdll_beacinfo=^aoshdll_beacinfo;
oshdll_dockinfo=packed record
 pos,dir,rot:vec;
end;   
aoshdll_dockinfo=array[0..10000]of oshdll_dockinfo;
paoshdll_dockinfo=^aoshdll_dockinfo;
oshdll_attachinfo=packed record
 ischild,loose:integer;
 range:double;
 pos,dir,rot:vec;    
 name,id:array[0..254]of char;
end;   
aoshdll_attachinfo=array[0..10000]of oshdll_attachinfo;
paoshdll_attachinfo=^aoshdll_attachinfo;

oshdll_arminfo=packed record
 range_low,range_high:double;
 seq,grap_seq,grap_attach:integer;
 tip:array[0..2]of vec;
 name:array[0..254]of char;
end;  
aoshdll_arminfo=array[0..10000]of oshdll_arminfo;
paoshdll_arminfo=^aoshdll_arminfo;

oshdll_payinfo=packed record
 mesh,mesh_cnt:integer;
 mass:double;
 speed,rot_speed:vec;
 module,name:array[0..254]of char;
end;  
aoshdll_payinfo=array[0..10000]of oshdll_payinfo;
paoshdll_payinfo=^aoshdll_payinfo;

oshdll_crewinfo=packed record
 air_pos,air_siz,eva_pos,eva_rot:vec;
 maxcrew:integer;
end;
aoshdll_crewinfo=array[0..10000]of oshdll_crewinfo;
paoshdll_crewinfo=^aoshdll_crewinfo;
oshdll_airinfo=packed record
 tp,anim,align,axis:integer;
 c,s,a:double;
 v:vec;
end;
aoshdll_airinfo=array[0..10000]of oshdll_airinfo;
paoshdll_airinfo=^aoshdll_airinfo;
//############################################################################//
type
oshdll_data=record 
 prop:array of oshdll_propinfo;
 th:array of oshdll_thinfo;
 exh:array of oshdll_exhinfo;
 msh:array of oshdll_mshinfo;
 anim:array of oshdll_animinfo;
 vc:array of oshdll_vcinfo;
 td:array of oshdll_tdinfo;
 beac:array of oshdll_beacinfo;
 dock:array of oshdll_dockinfo;
 crew:array of oshdll_crewinfo; 
 air:array of oshdll_airinfo;
 att:array of oshdll_attachinfo;
 arm:array of oshdll_arminfo;
 pay:array of oshdll_payinfo;
end;
poshdll_data=^oshdll_data;

xoshdll_data=record 
 prop:paoshdll_propinfo;
 th:paoshdll_thinfo;
 exh:paoshdll_exhinfo;
 msh:paoshdll_mshinfo;
 anim:paoshdll_animinfo;
 vc:paoshdll_vcinfo;
 td:paoshdll_tdinfo;
 beac:paoshdll_beacinfo;
 dock:paoshdll_dockinfo;
 crew:paoshdll_crewinfo; 
 air:paoshdll_airinfo;
 att:paoshdll_attachinfo;
 arm:paoshdll_arminfo;
 pay:paoshdll_payinfo;
 dynbuf:pointer;
 dbs:integer;
end;
pxoshdll_data=^xoshdll_data;
//############################################################################//
//############################################################################//
var
main_cfg:oshdll_config;
main_dat:oshdll_data; 
anim_st:array of integer;  

maxcrew:integer;
                         
//############################################################################//        
function tdcrgba(r,g,b,a:single):crgba;
function max2(a,b:double):double;
function min2i(a,b:integer):integer;
function tvec (x,y,z:double):vec;
//############################################################################//
function vfopen(var f:file;n:string;m:integer):dword;
procedure vfclose(var f:file);
procedure vfread(var f:file;p:pointer;s:integer);
function vffilesize(var f:vfile):integer;
//############################################################################//
implementation  
//############################################################################//
function tdcrgba(r,g,b,a:single):crgba;
begin      
{$ifndef BGR}
 result[0]:=round(r*255);
 result[1]:=round(g*255);
 result[2]:=round(b*255);
 result[3]:=round(a*255);   
{$else}   
 result[2]:=round(r*255);
 result[1]:=round(g*255);
 result[0]:=round(b*255);
 result[3]:=round(a*255);  
{$endif}
end;   
//############################################################################//
function max2(a,b:double):double;
begin
 if a>b then result:=a else result:=b;
end;
//############################################################################//
function min2i(a,b:integer):integer;
begin
 if a<b then result:=a else result:=b;
end; 
//############################################################################//
function tvec (x,y,z:double):vec;
begin
 result.x:=x;
 result.y:=y;
 result.z:=z;
end;     
//##############################################################################
function vfopen(var f:file;n:string;m:integer):dword;
begin
 if n[1]='/' then n:=copy(n,2,10000);
 if m=1 then if not fileexists(n) then begin result:=9999; exit; end;
 assignfile(f,n);
 filemode:=0;
 if m=1 then reset(f,1); 
 if m=2 then rewrite(f,1); 
 result:=VFERR_OK;
end;
procedure vfclose(var f:file);
begin
 closefile(f);
end;
procedure vfread(var f:file;p:pointer;s:integer);
begin
 blockread(f,p^,s);
end;
function vffilesize(var f:vfile):integer;
begin
 result:=filesize(f);
end; 
//############################################################################//
begin    
end.
//############################################################################//