//############################################################################//  
//Made in 2005-2013 by Artyom Litvinovich
//Modified 2013-02-10 by Friedrich Kastner-Masilko
//Dynamic vessel DLL h
//############################################################################//
#pragma once
#include "Orbitersdk.h"
#include "SC3Data.h"
#define CUSTOMDIRSLENGTH 1024    
//############################################################################//
#define SPACECRAFTCLASS   "spacecraft\\spacecraft"
#define SPACECRAFTINIPATH ".\\Config\\Spacecraft\\%s.ini"
#define CONFIGDIRTAG   "ConfigDir"
#define MESHDIRTAG     "MeshDir"
#define TEXTUREDIRTAG  "TextureDir"
#define HIGHTEXDIRTAG  "HightexDir"
#define SCENARIODIRTAG "ScenarioDir"
#define CONFIGDIRDEFAULT   ".\\Config\\"
#define MESHDIRDEFAULT     ".\\Meshes\\"
#define TEXTUREDIRDEFAULT  ".\\Textures\\"
#define HIGHTEXDIRDEFAULT  ".\\Textures2\\"
#define SCENARIODIRDEFAULT ".\\Scenarios\\"
#define CONFIGPATH    "%s%s.cfg"
#define CONFIG2PATH   "%sVessels\\%s.cfg"
#define ORBITERCONFIG "Orbiter.cfg"
#define CONFIGEXCEPTION "abort: neither vessel configuration \"%s%s.cfg\" nor \"%sVessels\\%s.cfg\" was found!"  
//############################################################################//   
#define ANI_RUN 1
#define ANI_BACK_RUN -1
#define ANI_PAUSE 2
#define ANI_BACK_PAUSE -2
//############################################################################//


HINSTANCE g_hInst;  // module instance handle
DWORD g_dwCmd;      // custom function identifier
//Vessel class
class GenericVessel:public VESSEL3{
public:
 GenericVessel(OBJHANDLE hObj,int fmodel);
 ~GenericVessel();
 void clbkSetClassCaps(FILEHANDLE cfg);
 void clbkLoadStateEx(FILEHANDLE scn,void *status);
 void clbkSaveState(FILEHANDLE scn);          
 void clbkPreStep (double simt,double simdt,double mjd);
 void clbkPostStep(double simt,double simdt,double mjd);
 bool clbkDrawHUD(int mode, const HUDPAINTSPEC *hps, oapi::Sketchpad *skp);
 int  clbkConsumeBufferedKey(DWORD key,bool down,char *kstate);
 int  clbkConsumeDirectKey(char *kstate);
 bool clbkLoadVC(int id);
 bool do_reload(); 
 
private:           
 //INI file data
 SC3Data::Vessel sc3;
 void do_init();
 void do_clean();

 char configDir[CUSTOMDIRSLENGTH];
 char meshDir[CUSTOMDIRSLENGTH];
 char textureDir[CUSTOMDIRSLENGTH];
 char hightexDir[CUSTOMDIRSLENGTH];
 char scenarioDir[CUSTOMDIRSLENGTH];

 //Methods
 void toggle_attach(int point);
 
 //Thrusters
 PROPELLANT_HANDLE *ph_h;
 THRUSTER_HANDLE *th_h;
 THGROUP_HANDLE *thg_h;
 UINT *exh_h;

 //Mesh
 MESHHANDLE *msh_h;
 int *msh_idh;

 //Animations
 genericvessel_animinfo *ani;

 //Robotic arm
 int arm_on,arm_sel,arm_blank;
 VECTOR3 arm_tip[3];

 //Attachments
 ATTACHMENTHANDLE *att_h;
 int att_on,att_sel,att_blank;

};
//############################################################################//