//#include <vcclr.h>
#include "orbitersdk.h"
#include "Vessel2Base.h"
#include "Vessel2.h"
#include "Vessel.h"

using namespace System;
using namespace System::Reflection;
using namespace System::Runtime::InteropServices;
using namespace Orbiter;

[assembly:AssemblyVersionAttribute("1.0.0.0")];

namespace Orbiter
{
	namespace Wrapper
	{
		class Vessel2;
		Vessel::Vessel(VESSEL *vessel)
		{
			this->vessel=vessel;
		}
		Vessel::~Vessel()
		{
		}
		IntPtr Vessel::Handle::get(void){return (IntPtr)vessel->GetHandle();}
		String^ Vessel::Name::get(void){return Marshal::PtrToStringAnsi((IntPtr)(void *)vessel->GetName());}
		String^ Vessel::ClassName::get(void){return String::Empty;/*return Marshal::PtrToStringAnsi((IntPtr)(void *)vessel->GetClassName());*/}
		int Vessel::FlightModel::get(void){return vessel->GetFlightModel();}
		int Vessel::DamageModel::get(void){return vessel->GetDamageModel();}
		bool Vessel::FocusEnabled::get(void){return vessel->GetEnableFocus();}
		void Vessel::FocusEnabled::set(bool value){vessel->SetEnableFocus(value);}
		double Vessel::Size::get(void){return vessel->GetSize();}
		void Vessel::Size::set(double value){vessel->SetSize(value);}
		double Vessel::ClipRadius::get(void){return vessel->GetClipRadius();}
		void Vessel::ClipRadius::set(double value){vessel->SetClipRadius(value);}
		double Vessel::Mass::get(void){return vessel->GetMass();}
		double Vessel::EmptyMass::get(void){return vessel->GetEmptyMass();}
		void Vessel::EmptyMass::set(double value){vessel->SetEmptyMass(value);}
		double Vessel::ISP::get(void){return vessel->GetISP();}
		void Vessel::SetVisibilityLimit(double vislimit){SetVisibilityLimit(vislimit, -1);}
		void Vessel::SetVisibilityLimit(double vislimit, double spotlimit){vessel->SetVisibilityLimit(vislimit, spotlimit);}
		Interfaces::CW Vessel::CW::get(void)
		{
			Interfaces::CW cw;
			vessel->GetCW(cw.ZPositive, cw.ZNegative, cw.X, cw.Y);
			return cw;
		}
		void Vessel::CW::set(Interfaces::CW value)
		{
			vessel->SetCW(value.ZPositive,value.ZNegative, value.X, value.Y);
		}
		double Vessel::WingAspect::get(void){return vessel->GetWingAspect();}
		void Vessel::WingAspect::set(double value){vessel->SetWingAspect(value);}
		double Vessel::WingEffectiveness::get(void){return vessel->GetWingEffectiveness();}
		void Vessel::WingEffectiveness::set(double value){vessel->SetWingEffectiveness(value);}
		Interfaces::Vector3^ Vessel::CrossSections::get(void)
		{
			VECTOR3 vector;
			vessel->GetCrossSections(vector);
			return gcnew Interfaces::Vector3(vector.x, vector.y, vector.z);
		}
		void Vessel::CrossSections::set(Interfaces::Vector3^ value){vessel->SetCrossSections(_V(value->X, value->Y, value->Z));}
		Interfaces::Vector3^ Vessel::RotationalDrag::get(void)
		{
			VECTOR3 vector;
			vessel->GetRotDrag(vector);
			return gcnew Interfaces::Vector3(vector.x, vector.y, vector.z);
		}
		void Vessel::RotationalDrag::set(Interfaces::Vector3^ value){vessel->SetRotDrag(_V(value->X, value->Y, value->Z));}
		double Vessel::PitchMomentScale::get(void){return vessel->GetPitchMomentScale();}
		void Vessel::PitchMomentScale::set(double value){vessel->SetPitchMomentScale(value);}
		double Vessel::BankMomentScale::get(void){return vessel->GetBankMomentScale();}
		void Vessel::BankMomentScale::set(double value){vessel->SetBankMomentScale(value);}
		double Vessel::TrimScale::get(void){return vessel->GetTrimScale();}
		void Vessel::TrimScale::set(double value){vessel->SetTrimScale(value);}
		Interfaces::Vector3^ Vessel::PMI::get(void)
		{
			VECTOR3 vector;
			vessel->GetPMI(vector);
			return gcnew Interfaces::Vector3(vector.x, vector.y, vector.z);
		}
		void Vessel::PMI::set(Interfaces::Vector3^ value){vessel->SetPMI(_V(value->X, value->Y, value->Z));}
		Interfaces::Vector3^ Vessel::CameraOffset::get(void)
		{
			VECTOR3 vector;
			vessel->GetCameraOffset(vector);
			return gcnew Interfaces::Vector3(vector.x, vector.y, vector.z);
		}
		void Vessel::CameraOffset::set(Interfaces::Vector3^ value){vessel->SetCameraOffset(_V(value->X, value->Y, value->Z));}
		void Vessel::LiftCoefficient::set(Interfaces::LiftCoefficientDelegate^ value)
		{
			liftCoefficientDelegate = value;
			IntPtr p = Marshal::GetFunctionPointerForDelegate(value);
			vessel->SetLiftCoeffFunc(static_cast<LiftCoeffFunc>(p.ToPointer()));			
		}

		void Vessel::SetDockParameters(System::IntPtr dock, Interfaces::DockParameters parameters)
		{
			vessel->SetDockParams((DOCKHANDLE)dock,
				_V(parameters.Position->X, parameters.Position->Y, parameters.Position->Z),
				_V(parameters.Direction->X, parameters.Direction->Y, parameters.Direction->Z),
				_V(parameters.Rotation->X, parameters.Rotation->Y, parameters.Rotation->Z));
		}

		void Vessel::SetDockParameters(Interfaces::DockParameters parameters)
		{
			vessel->SetDockParams(
				_V(parameters.Position->X, parameters.Position->Y, parameters.Position->Z),
				_V(parameters.Direction->X, parameters.Direction->Y, parameters.Direction->Z),
				_V(parameters.Rotation->X, parameters.Rotation->Y, parameters.Rotation->Z));
		}

		Interfaces::DockParameters Vessel::GetDockParameters(System::IntPtr dock)
		{
			VECTOR3 position, direction, rotation;
			vessel->GetDockParams((DOCKHANDLE)dock, position, direction, rotation);
			Interfaces::DockParameters result;
			result.Position=gcnew Interfaces::Vector3(position.x, position.y, position.z);
			result.Direction=gcnew Interfaces::Vector3(direction.x, direction.y, direction.z);
			result.Rotation=gcnew Interfaces::Vector3(rotation.x, rotation.y, rotation.z);
			return result;
		}

		Interfaces::TouchDownPoints Vessel::TouchDownPoints::get(void)
		{
			VECTOR3 pt1, pt2, pt3;
			vessel->GetTouchdownPoints(pt1, pt2, pt3);
			Interfaces::TouchDownPoints points;
			points[0]=gcnew Interfaces::Vector3(pt1.x, pt1.y, pt1.z);
			points[1]=gcnew Interfaces::Vector3(pt2.x, pt2.y, pt2.z);
			points[2]=gcnew Interfaces::Vector3(pt3.x, pt3.y, pt3.z);
			return points;
		}

		void Vessel::TouchDownPoints::set(Interfaces::TouchDownPoints value)
		{
			vessel->SetTouchdownPoints(
				_V(value[0]->X, value[0]->Y, value[0]->Z),
				_V(value[1]->X, value[1]->Y, value[1]->Z),
				_V(value[2]->X, value[2]->Y, value[2]->Z));
		}

		UINT Vessel::AddMesh(IntPtr mesh){return AddMesh(mesh, gcnew Interfaces::Vector3(0, 0, 0));}
		UINT Vessel::AddMesh(IntPtr mesh, Interfaces::Vector3 ^offset){return vessel->AddMesh((MESHHANDLE)mesh, &_V(offset->X, offset->Y, offset->Z));}
		UINT Vessel::AddMesh(System::String ^name){return AddMesh(name, gcnew Interfaces::Vector3(0, 0, 0));}
		UINT Vessel::AddMesh(System::String ^name, Interfaces::Vector3 ^offset)
		{
			IntPtr buf=Marshal::StringToHGlobalAnsi(name);
			UINT result=vessel->AddMesh((char *)(void *)buf, &_V(offset->X, offset->Y, offset->Z));
			Marshal::FreeHGlobal(buf);
			return result;
		}

		IntPtr Vessel::CreatePropellantResource(double maxmass){return (IntPtr)vessel->CreatePropellantResource(maxmass);}
		IntPtr Vessel::CreatePropellantResource(double maxmass, double mass){return (IntPtr)vessel->CreatePropellantResource(maxmass, mass);}
		IntPtr Vessel::CreatePropellantResource(double maxmass, double mass, double efficiency){return (IntPtr)vessel->CreatePropellantResource(maxmass, mass, efficiency);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust, System::IntPtr propellant, double ispVacuum, double ispReference, double pressureReference){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust,(PROPELLANT_HANDLE) propellant, ispVacuum, ispReference, pressureReference);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust, System::IntPtr propellant, double ispVacuum, double ispReference){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust,(PROPELLANT_HANDLE) propellant, ispVacuum, ispReference);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust, System::IntPtr propellant, double ispVacuum){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust,(PROPELLANT_HANDLE) propellant, ispVacuum);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust, System::IntPtr propellant){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust,(PROPELLANT_HANDLE) propellant);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust);}
		IntPtr Vessel::CreateThrusterGroup(array<IntPtr> ^thruster, Interfaces::ThrusterGroup group)
		{
			pin_ptr<IntPtr> th=&thruster[0];
			return (IntPtr)vessel->CreateThrusterGroup((THRUSTER_HANDLE *)th, thruster->Length, (THGROUP_TYPE)group);
		}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, System::IntPtr texture){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, _V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), (SURFHANDLE)texture);}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, _V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z));}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, double lengthOffset, System::IntPtr texture){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, lengthOffset, (SURFHANDLE)texture);}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, double lengthOffset){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, lengthOffset);}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, System::IntPtr texture){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, (SURFHANDLE)texture);}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale);}
		IntPtr Vessel::AddExhaustStream(System::IntPtr thruster, Interfaces::Vector3 ^position, Interfaces::ParticleStreamSpecification particleStream)
		{
			PARTICLESTREAMSPEC *pss=new PARTICLESTREAMSPEC;
			Marshal::StructureToPtr(particleStream, (IntPtr)pss, false);
			return (IntPtr)vessel->AddExhaustStream((THRUSTER_HANDLE)thruster, _V(position->X, position->Y, position->Z), pss);			
		}
		IntPtr Vessel::AddExhaustStream(System::IntPtr thruster, Interfaces::Vector3 ^position){return (IntPtr)vessel->AddExhaustStream((THRUSTER_HANDLE)thruster, _V(position->X, position->Y, position->Z));}
		IntPtr Vessel::AddExhaustStream(System::IntPtr thruster, Interfaces::ParticleStreamSpecification particleStream)
		{
			PARTICLESTREAMSPEC *pss=new PARTICLESTREAMSPEC;
			Marshal::StructureToPtr(particleStream, (IntPtr)pss, false);
			return (IntPtr)vessel->AddExhaustStream((THRUSTER_HANDLE)thruster, pss);
		}
		IntPtr Vessel::AddExhaustStream(System::IntPtr thruster){return (IntPtr)vessel->AddExhaustStream((THRUSTER_HANDLE)thruster);}
		IntPtr Vessel::AtmosphereReference::get(void){return (IntPtr)vessel->GetAtmRef();}
		double Vessel::AtmosphereDensity::get(void){return vessel->GetAtmDensity();}
		double Vessel::AtmospherePressure::get(void){return vessel->GetAtmPressure();}
		double Vessel::AtmosphereTemperature::get(void){return vessel->GetAtmTemperature();}
		double Vessel::MachNumber::get(void){return vessel->GetMachNumber();}
		double Vessel::DynamicPressure::get(void){return vessel->GetDynPressure();}
		double Vessel::GetThrusterLevel(System::IntPtr thruster){return vessel->GetThrusterLevel((THRUSTER_HANDLE)(void *)thruster);}
		void Vessel::SetThrusterLevel(System::IntPtr thruster, double level){vessel->SetThrusterLevel((THRUSTER_HANDLE)(void *)thruster, level);}

		IntPtr Vessel::Init(IntPtr vessel, int flightmodel, Interfaces::Vessel2^ vessel2)
		{
			return (IntPtr)(new Vessel2((OBJHANDLE)vessel, flightmodel, vessel2));
		}
		void Vessel::Exit(IntPtr vessel)
		{			
			if (vessel!=IntPtr::Zero) delete (Vessel2 *)(VESSEL2 *)(VESSEL *)(void *)vessel;
		}
	}
}

