namespace Orbiter.Interfaces
{
    public class Constants
    {
        public const double PI = 3.14159265358979;
        public const double PI05 = 1.57079632679490;
        public const double Radiant = PI / 180.0;
        public const double DEG = 180.0 / PI;
        public const double C0 = 299792458.0;   // speed of light in vacuum [m/s]
        public const double TAUA = 499.004783806; // light time for 1 AU [s]
        public const double AU = C0 * TAUA;       // astronomical unit (mean geocentric distance of the sun) [m]
        public const double GGRAV = 6.67259e-11;   // gravitational constant [m^3 kg^-1 s^-2]
        public const double G = 9.81;          // gravitational acceleration [m/s^2] at Earth mean radius
        public const double ATMP = 101.4e3;       // atmospheric pressure [Pa] at Earth sea level
        public const double ATMD = 1.293;         // atmospheric density [kg/m^3] at Earth sea level
    }
}
