//#include <vcclr.h>

#include "orbitersdk.h"
#include "Vessel2Base.h"
#include "Vessel2.h"
#include "Vessel.h"

using namespace System;
using namespace System::Reflection;
using namespace System::Runtime::InteropServices;
using namespace Orbiter;

[assembly:AssemblyVersionAttribute("1.0.0.0")];

namespace Orbiter
{
	namespace Wrapper
	{
		class Vessel2;
		Vessel::Vessel(VESSEL *vessel)
		{
			this->vessel=vessel;
			this->coefficientDelegatesByAirFoil=gcnew System::Collections::Hashtable();
			this->coefficientDelegatesByKey=gcnew System::Collections::Hashtable();
		}
		Vessel::~Vessel()
		{
		}
		IntPtr Vessel::Handle::get(void){return (IntPtr)vessel->GetHandle();}
		String^ Vessel::Name::get(void){return Marshal::PtrToStringAnsi((IntPtr)(void *)vessel->GetName());}
		String^ Vessel::ClassName::get(void){return Marshal::PtrToStringAnsi((IntPtr)(void *)vessel->GetClassNameA());}
		int Vessel::FlightModel::get(void){return vessel->GetFlightModel();}
		int Vessel::DamageModel::get(void){return vessel->GetDamageModel();}
		bool Vessel::FocusEnabled::get(void){return vessel->GetEnableFocus();}
		void Vessel::FocusEnabled::set(bool value){vessel->SetEnableFocus(value);}
		double Vessel::Size::get(void){return vessel->GetSize();}
		void Vessel::Size::set(double value){vessel->SetSize(value);}
		double Vessel::ClipRadius::get(void){return vessel->GetClipRadius();}
		void Vessel::ClipRadius::set(double value){vessel->SetClipRadius(value);}
		double Vessel::Mass::get(void){return vessel->GetMass();}
		double Vessel::EmptyMass::get(void){return vessel->GetEmptyMass();}
		void Vessel::EmptyMass::set(double value){vessel->SetEmptyMass(value);}
		double Vessel::ISP::get(void){return vessel->GetISP();}
		void Vessel::SetVisibilityLimit(double vislimit){SetVisibilityLimit(vislimit, -1);}
		void Vessel::SetVisibilityLimit(double vislimit, double spotlimit){vessel->SetVisibilityLimit(vislimit, spotlimit);}
		Interfaces::CW Vessel::CW::get(void)
		{
			Interfaces::CW cw;
			vessel->GetCW(cw.ZPositive, cw.ZNegative, cw.X, cw.Y);
			return cw;
		}
		void Vessel::CW::set(Interfaces::CW value)
		{
			vessel->SetCW(value.ZPositive,value.ZNegative, value.X, value.Y);
		}
		double Vessel::WingAspect::get(void){return vessel->GetWingAspect();}
		void Vessel::WingAspect::set(double value){vessel->SetWingAspect(value);}
		double Vessel::WingEffectiveness::get(void){return vessel->GetWingEffectiveness();}
		void Vessel::WingEffectiveness::set(double value){vessel->SetWingEffectiveness(value);}
		Interfaces::Vector3^ Vessel::CrossSections::get(void)
		{
			VECTOR3 vector;
			vessel->GetCrossSections(vector);
			return gcnew Interfaces::Vector3(vector.x, vector.y, vector.z);
		}
		void Vessel::CrossSections::set(Interfaces::Vector3^ value){vessel->SetCrossSections(_V(value->X, value->Y, value->Z));}
		Interfaces::Vector3^ Vessel::RotationalDrag::get(void)
		{
			VECTOR3 vector;
			vessel->GetRotDrag(vector);
			return gcnew Interfaces::Vector3(vector.x, vector.y, vector.z);
		}
		void Vessel::RotationalDrag::set(Interfaces::Vector3^ value){vessel->SetRotDrag(_V(value->X, value->Y, value->Z));}
		double Vessel::PitchMomentScale::get(void){return vessel->GetPitchMomentScale();}
		void Vessel::PitchMomentScale::set(double value){vessel->SetPitchMomentScale(value);}
		double Vessel::BankMomentScale::get(void){return vessel->GetBankMomentScale();}
		void Vessel::BankMomentScale::set(double value){vessel->SetBankMomentScale(value);}
		double Vessel::TrimScale::get(void){return vessel->GetTrimScale();}
		void Vessel::TrimScale::set(double value){vessel->SetTrimScale(value);}
		Interfaces::Vector3^ Vessel::PMI::get(void)
		{
			VECTOR3 vector;
			vessel->GetPMI(vector);
			return gcnew Interfaces::Vector3(vector.x, vector.y, vector.z);
		}
		void Vessel::PMI::set(Interfaces::Vector3^ value){vessel->SetPMI(_V(value->X, value->Y, value->Z));}
		Interfaces::Vector3^ Vessel::CameraOffset::get(void)
		{
			VECTOR3 vector;
			vessel->GetCameraOffset(vector);
			return gcnew Interfaces::Vector3(vector.x, vector.y, vector.z);
		}
		void Vessel::CameraOffset::set(Interfaces::Vector3^ value){vessel->SetCameraOffset(_V(value->X, value->Y, value->Z));}
		void Vessel::LiftCoefficient::set(Interfaces::LiftCoefficientDelegate^ value)
		{
			liftCoefficientDelegate = value;
			IntPtr p = Marshal::GetFunctionPointerForDelegate(value);
			vessel->SetLiftCoeffFunc(static_cast<LiftCoeffFunc>(p.ToPointer()));			
		}

		void Vessel::SetDockParameters(System::IntPtr dock, Interfaces::DockParameters parameters)
		{
			vessel->SetDockParams((DOCKHANDLE)dock,
				_V(parameters.Position->X, parameters.Position->Y, parameters.Position->Z),
				_V(parameters.Direction->X, parameters.Direction->Y, parameters.Direction->Z),
				_V(parameters.Rotation->X, parameters.Rotation->Y, parameters.Rotation->Z));
		}

		void Vessel::SetDockParameters(Interfaces::DockParameters parameters)
		{
			vessel->SetDockParams(
				_V(parameters.Position->X, parameters.Position->Y, parameters.Position->Z),
				_V(parameters.Direction->X, parameters.Direction->Y, parameters.Direction->Z),
				_V(parameters.Rotation->X, parameters.Rotation->Y, parameters.Rotation->Z));
		}

		Interfaces::DockParameters Vessel::GetDockParameters(System::IntPtr dock)
		{
			VECTOR3 position, direction, rotation;
			vessel->GetDockParams((DOCKHANDLE)dock, position, direction, rotation);
			Interfaces::DockParameters result;
			result.Position=gcnew Interfaces::Vector3(position.x, position.y, position.z);
			result.Direction=gcnew Interfaces::Vector3(direction.x, direction.y, direction.z);
			result.Rotation=gcnew Interfaces::Vector3(rotation.x, rotation.y, rotation.z);
			return result;
		}

		Interfaces::TouchDownPoints Vessel::TouchDownPoints::get(void)
		{
			VECTOR3 pt1, pt2, pt3;
			vessel->GetTouchdownPoints(pt1, pt2, pt3);
			Interfaces::TouchDownPoints points;
			points[0]=gcnew Interfaces::Vector3(pt1.x, pt1.y, pt1.z);
			points[1]=gcnew Interfaces::Vector3(pt2.x, pt2.y, pt2.z);
			points[2]=gcnew Interfaces::Vector3(pt3.x, pt3.y, pt3.z);
			return points;
		}

		void Vessel::TouchDownPoints::set(Interfaces::TouchDownPoints value)
		{
			vessel->SetTouchdownPoints(
				_V(value[0]->X, value[0]->Y, value[0]->Z),
				_V(value[1]->X, value[1]->Y, value[1]->Z),
				_V(value[2]->X, value[2]->Y, value[2]->Z));
		}

		UINT Vessel::AddMesh(IntPtr mesh){return AddMesh(mesh, gcnew Interfaces::Vector3(0, 0, 0));}
		UINT Vessel::AddMesh(IntPtr mesh, Interfaces::Vector3 ^offset){return vessel->AddMesh((MESHHANDLE)mesh, &_V(offset->X, offset->Y, offset->Z));}
		UINT Vessel::AddMesh(System::String ^name){return AddMesh(name, gcnew Interfaces::Vector3(0, 0, 0));}
		UINT Vessel::AddMesh(System::String ^name, Interfaces::Vector3 ^offset)
		{
			IntPtr buf=Marshal::StringToHGlobalAnsi(name);
			UINT result=vessel->AddMesh((char *)(void *)buf, &_V(offset->X, offset->Y, offset->Z));
			Marshal::FreeHGlobal(buf);
			return result;
		}

		IntPtr Vessel::CreatePropellantResource(double maxmass){return (IntPtr)vessel->CreatePropellantResource(maxmass);}
		IntPtr Vessel::CreatePropellantResource(double maxmass, double mass){return (IntPtr)vessel->CreatePropellantResource(maxmass, mass);}
		IntPtr Vessel::CreatePropellantResource(double maxmass, double mass, double efficiency){return (IntPtr)vessel->CreatePropellantResource(maxmass, mass, efficiency);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust, System::IntPtr propellant, double ispVacuum, double ispReference, double pressureReference){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust,(PROPELLANT_HANDLE) propellant, ispVacuum, ispReference, pressureReference);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust, System::IntPtr propellant, double ispVacuum, double ispReference){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust,(PROPELLANT_HANDLE) propellant, ispVacuum, ispReference);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust, System::IntPtr propellant, double ispVacuum){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust,(PROPELLANT_HANDLE) propellant, ispVacuum);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust, System::IntPtr propellant){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust,(PROPELLANT_HANDLE) propellant);}
		IntPtr Vessel::CreateThruster(Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, double maximumVacuumThrust){return (IntPtr)vessel->CreateThruster(_V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), maximumVacuumThrust);}
		IntPtr Vessel::CreateThrusterGroup(array<IntPtr> ^thruster, Interfaces::ThrusterGroup group)
		{
			pin_ptr<IntPtr> th=&thruster[0];
			return (IntPtr)vessel->CreateThrusterGroup((THRUSTER_HANDLE *)th, thruster->Length, (THGROUP_TYPE)group);
		}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction, System::IntPtr texture){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, _V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z), (SURFHANDLE)texture);}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, Interfaces::Vector3 ^position, Interfaces::Vector3 ^direction){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, _V(position->X, position->Y, position->Z), _V(direction->X, direction->Y, direction->Z));}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, double lengthOffset, System::IntPtr texture){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, lengthOffset, (SURFHANDLE)texture);}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, double lengthOffset){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, lengthOffset);}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale, System::IntPtr texture){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale, (SURFHANDLE)texture);}
		UINT Vessel::AddExhaust(System::IntPtr thruster, double lengthScale, double widthScale){return vessel->AddExhaust((THRUSTER_HANDLE)thruster, lengthScale, widthScale);}
		IntPtr Vessel::AddExhaustStream(System::IntPtr thruster, Interfaces::Vector3 ^position, Interfaces::ParticleStreamSpecification particleStream)
		{
			PARTICLESTREAMSPEC *pss=new PARTICLESTREAMSPEC;
			Marshal::StructureToPtr(particleStream, (IntPtr)pss, false);
			return (IntPtr)vessel->AddExhaustStream((THRUSTER_HANDLE)thruster, _V(position->X, position->Y, position->Z), pss);			
		}
		IntPtr Vessel::AddExhaustStream(System::IntPtr thruster, Interfaces::Vector3 ^position){return (IntPtr)vessel->AddExhaustStream((THRUSTER_HANDLE)thruster, _V(position->X, position->Y, position->Z));}
		IntPtr Vessel::AddExhaustStream(System::IntPtr thruster, Interfaces::ParticleStreamSpecification particleStream)
		{
			PARTICLESTREAMSPEC *pss=new PARTICLESTREAMSPEC;
			Marshal::StructureToPtr(particleStream, (IntPtr)pss, false);
			return (IntPtr)vessel->AddExhaustStream((THRUSTER_HANDLE)thruster, pss);
		}
		IntPtr Vessel::AddExhaustStream(System::IntPtr thruster){return (IntPtr)vessel->AddExhaustStream((THRUSTER_HANDLE)thruster);}
		IntPtr Vessel::AtmosphereReference::get(void){return (IntPtr)vessel->GetAtmRef();}
		double Vessel::AtmosphereDensity::get(void){return vessel->GetAtmDensity();}
		double Vessel::AtmospherePressure::get(void){return vessel->GetAtmPressure();}
		double Vessel::AtmosphereTemperature::get(void){return vessel->GetAtmTemperature();}
		double Vessel::MachNumber::get(void){return vessel->GetMachNumber();}
		double Vessel::DynamicPressure::get(void){return vessel->GetDynPressure();}
		double Vessel::GetThrusterLevel(System::IntPtr thruster){return vessel->GetThrusterLevel((THRUSTER_HANDLE)(void *)thruster);}
		void Vessel::SetThrusterLevel(System::IntPtr thruster, double level){vessel->SetThrusterLevel((THRUSTER_HANDLE)(void *)thruster, level);}
		Interfaces::Vector3^ Vessel::ForceVector::get(void)
        {
            VECTOR3 F;
            vessel->GetForceVector(F);
            return gcnew Interfaces::Vector3(F.x,F.y,F.z);
        }
        Interfaces::Vector3^ Vessel::WeightVector::get(void)
        {
            VECTOR3 W;
            vessel->GetWeightVector(W);
            return gcnew Interfaces::Vector3(W.x,W.y,W.z);
        }
		Interfaces::Vector3^ Vessel::ThrustVector::get(void)
        {
            VECTOR3 T;
            vessel->GetThrustVector(T);
            return gcnew Interfaces::Vector3(T.x,T.y,T.z);
        }
		Interfaces::Vector3^ Vessel::LiftVector::get(void)
        {
            VECTOR3 L;
            vessel->GetLiftVector(L);
            return gcnew Interfaces::Vector3(L.x,L.y,L.z);
        }
		Interfaces::Vector3^ Vessel::DragVector::get(void)
        {
            VECTOR3 D;
            vessel->GetDragVector(D);
            return gcnew Interfaces::Vector3(D.x,D.y,D.z);
        }
		double Vessel::Drag::get(void)
        {
            return vessel->GetDrag();
        }
		double Vessel::Lift::get(void)
        {
            return vessel->GetLift();
        }

		void Vessel::DelPropellantResource (IntPtr propellant){vessel->DelPropellantResource((PROPELLANT_HANDLE &)propellant);}
		void Vessel::ClearPropellantResources (void){vessel->ClearPropellantResources();}
		IntPtr Vessel::GetPropellantHandleByIndex (unsigned int index){return (IntPtr)vessel->GetPropellantHandleByIndex(index);}
		void Vessel::SetDefaultPropellantResource (IntPtr propellant){vessel->SetDefaultPropellantResource((PROPELLANT_HANDLE)propellant);}
		void Vessel::SetPropellantMaxMass (IntPtr propellant, double maxMass){vessel->SetPropellantMaxMass((PROPELLANT_HANDLE)propellant, maxMass);}
		double Vessel::GetPropellantMaxMass (IntPtr propellant){return vessel->GetPropellantMaxMass((PROPELLANT_HANDLE)propellant);}
		void Vessel::SetPropellantEfficiency (IntPtr propellant, double efficiency){vessel->SetPropellantEfficiency((PROPELLANT_HANDLE)propellant, efficiency);}
		double Vessel::GetPropellantEfficiency (IntPtr propellant){return vessel->GetPropellantEfficiency((PROPELLANT_HANDLE)propellant);}
		void Vessel::SetPropellantMass (IntPtr propellant, double mass){vessel->SetPropellantMass((PROPELLANT_HANDLE)propellant, mass);}
		double Vessel::GetPropellantMass (IntPtr propellant){return vessel->GetPropellantMass((PROPELLANT_HANDLE)propellant);}
		double Vessel::GetPropellantFlowrate (IntPtr propellant){return vessel->GetPropellantFlowrate((PROPELLANT_HANDLE)propellant);}
		unsigned int Vessel::PropellantCount::get(void) {return vessel->GetPropellantCount();}
		double Vessel::TotalPropellantMass::get(void) {return vessel->GetTotalPropellantMass();}
		double Vessel::TotalPropellantFlowrate::get(void) {return vessel->GetTotalPropellantFlowrate();}
		double Vessel::FuelRate::get(void) {return vessel->GetFuelRate();}
		double Vessel::FuelMass::get(void) {return vessel->GetFuelMass();}		
		double Vessel::MaxFuelMass::get(void) {return vessel->GetMaxFuelMass();}
		void Vessel::FuelMass::set(double value) {vessel->SetFuelMass(value);}		
		void Vessel::MaxFuelMass::set(double value) {vessel->SetMaxFuelMass(value);}
		unsigned int Vessel::CreateAnimation(double initial_state){return vessel->CreateAnimation(initial_state);}
		IntPtr Vessel::AddAnimationComponent(unsigned int animation, double state0, double state1, Interfaces::MeshGroupTransformation ^transformation, System::IntPtr parent){return (IntPtr)vessel->AddAnimationComponent(animation, state0, state1, (MGROUP_TRANSFORM *)(void *)transformation->Native, (ANIMATIONCOMPONENT_HANDLE)parent);}
		IntPtr Vessel::AddAnimationComponent(unsigned int animation, double state0, double state1, Interfaces::MeshGroupTransformation ^transformation){return (IntPtr)vessel->AddAnimationComponent(animation, state0, state1, (MGROUP_TRANSFORM *)(void *)transformation->Native);}
		void Vessel::AlbedoRGB::set(Interfaces::Vector3^ value){vessel->SetAlbedoRGB(_V(value->X, value->Y, value->Z));}
		double Vessel::GravityGradientDamping::get(void) {return vessel->GetGravityGradientDamping();}
		void Vessel::GravityGradientDamping::set(double value)
		{
			if (!vessel->SetGravityGradientDamping(value))
				throw gcnew System::AccessViolationException("Extended vessel masses are disabled!");
		}
		void Vessel::SetSurfaceFrictionCoefficients(double longitudinal, double latitudinal){vessel->SetSurfaceFrictionCoeff(longitudinal, latitudinal);}
		void Vessel::MaxWheelbrakeForce::set(double value){vessel->SetMaxWheelbrakeForce(value);}
		void Vessel::SetWheelbrakeLevel(double level, int which, bool permanent){vessel->SetWheelbrakeLevel(level, which, permanent);}
		void Vessel::SetWheelbrakeLevel(double level, int which){vessel->SetWheelbrakeLevel(level, which);}
		void Vessel::SetWheelbrakeLevel(double level){vessel->SetWheelbrakeLevel(level);}
		double Vessel::GetWheelbrakeLevel(int which){return vessel->GetWheelbrakeLevel(which);}
		void Vessel::InitNavRadios(unsigned int navRadios){vessel->InitNavRadios((DWORD)navRadios);}
		void Vessel::IsTransponderEnabled::set(bool value){vessel->EnableTransponder(value);}
		void Vessel::CreateAirfoil(Orbiter::Interfaces::AirFoilOrientation align, Orbiter::Interfaces::Vector3 ^reference, Orbiter::Interfaces::AirFoilCoefficientDelegate ^coefficient, double chordLength, double wingArea, double aspectRatio)
		{
			IntPtr p = Marshal::GetFunctionPointerForDelegate(coefficient);
			array<Object^>^ payload=gcnew array<Object^>(3);
			payload[0]=coefficient;
			payload[1]=IntPtr::Zero;
			payload[2]=nullptr;
			coefficientDelegatesByAirFoil[coefficient]=payload;
			vessel->CreateAirfoil((AIRFOIL_ORIENTATION)align, _V(reference->X, reference->Y, reference->Z), static_cast<AirfoilCoeffFunc>(p.ToPointer()), chordLength, wingArea, aspectRatio);
		}
		IntPtr Vessel::CreateAirfoil2(Orbiter::Interfaces::AirFoilOrientation align, Orbiter::Interfaces::Vector3 ^reference, Orbiter::Interfaces::AirFoilCoefficientDelegate ^coefficient, double chordLength, double wingArea, double aspectRatio)
		{
			IntPtr p = Marshal::GetFunctionPointerForDelegate(coefficient);
			array<Object^>^ payload=gcnew array<Object^>(3);
			payload[0]=coefficient;
			payload[1]=IntPtr::Zero;
			payload[2]=nullptr;			
			IntPtr result=(IntPtr)vessel->CreateAirfoil2((AIRFOIL_ORIENTATION)align, _V(reference->X, reference->Y, reference->Z), static_cast<AirfoilCoeffFunc>(p.ToPointer()), chordLength, wingArea, aspectRatio);
			coefficientDelegatesByAirFoil[result]=payload;
			return result;
		}
		IntPtr Vessel::CreateAirfoil3(Orbiter::Interfaces::AirFoilOrientation align, Orbiter::Interfaces::Vector3 ^reference, Orbiter::Interfaces::AirFoilCoefficientExDelegate ^coefficient, System::Object ^context, double chordLength, double wingArea, double aspectRatio)
		{
			IntPtr p = Marshal::GetFunctionPointerForDelegate(coefficient);
			char *key=new char[1];
			array<Object^>^ payload=gcnew array<Object^>(3);
			payload[0]=coefficient;
			payload[1]=(IntPtr)key;
			payload[2]=context;			
			IntPtr result=(IntPtr)vessel->CreateAirfoil3((AIRFOIL_ORIENTATION)align, _V(reference->X, reference->Y, reference->Z), static_cast<AirfoilCoeffFuncEx>(p.ToPointer()), key, chordLength, wingArea, aspectRatio);
			coefficientDelegatesByAirFoil[result]=payload;
			coefficientDelegatesByKey[payload[1]]=payload;
			return result;
		}
		System::Object^ Vessel::GetAirFoilCoefficientFunctionContext(System::IntPtr key){return coefficientDelegatesByKey[key];}
		void Vessel::CreateControlSurface(Orbiter::Interfaces::ControlSurface type, double area, double liftCoefficientShift, Orbiter::Interfaces::Vector3 ^reference){vessel->CreateControlSurface((AIRCTRL_TYPE)type, area, liftCoefficientShift, _V(reference->X, reference->Y, reference->Z));}
		void Vessel::CreateControlSurface(Orbiter::Interfaces::ControlSurface type, double area, double liftCoefficientShift, Orbiter::Interfaces::Vector3 ^reference, int axis){vessel->CreateControlSurface((AIRCTRL_TYPE)type, area, liftCoefficientShift, _V(reference->X, reference->Y, reference->Z), axis);}
		void Vessel::CreateControlSurface(Orbiter::Interfaces::ControlSurface type, double area, double liftCoefficientShift, Orbiter::Interfaces::Vector3 ^reference, int axis, unsigned int animation){vessel->CreateControlSurface((AIRCTRL_TYPE)type, area, liftCoefficientShift, _V(reference->X, reference->Y, reference->Z), axis, animation);}
		IntPtr Vessel::CreateControlSurface2(Orbiter::Interfaces::ControlSurface type, double area, double liftCoefficientShift, Orbiter::Interfaces::Vector3 ^reference, int axis, unsigned int animation){return (IntPtr)vessel->CreateControlSurface2((AIRCTRL_TYPE)type, area, liftCoefficientShift, _V(reference->X, reference->Y, reference->Z), axis, animation);}
		IntPtr Vessel::CreateControlSurface2(Orbiter::Interfaces::ControlSurface type, double area, double liftCoefficientShift, Orbiter::Interfaces::Vector3 ^reference, int axis){return (IntPtr)vessel->CreateControlSurface2((AIRCTRL_TYPE)type, area, liftCoefficientShift, _V(reference->X, reference->Y, reference->Z), axis);}
		IntPtr Vessel::CreateControlSurface2(Orbiter::Interfaces::ControlSurface type, double area, double liftCoefficientShift, Orbiter::Interfaces::Vector3 ^reference){return (IntPtr)vessel->CreateControlSurface2((AIRCTRL_TYPE)type, area, liftCoefficientShift, _V(reference->X, reference->Y, reference->Z));}
		void Vessel::CreateVariableDragElement(Interfaces::DoublePointer ^drag, double factor, Orbiter::Interfaces::Vector3 ^reference){vessel->CreateVariableDragElement((double *)(void *)drag->Native, factor, _V(reference->X, reference->Y, reference->Z));}
		void Vessel::SetMeshVisibilityMode(unsigned int mesh, short mode){vessel->SetMeshVisibilityMode(mesh, mode);}
		void Vessel::AddBeacon(Orbiter::Interfaces::BeaconLightSpecification beacon){vessel->AddBeacon((BEACONLIGHTSPEC *)(void *)beacon.Native);}
		Interfaces::AttitudeMode Vessel::AttitudeMode::get(){return (Interfaces::AttitudeMode)vessel->GetAttitudeMode();}
		void Vessel::AttitudeMode::set(Interfaces::AttitudeMode value){vessel->SetAttitudeMode((int)value);}
		
		IntPtr Vessel::Init(IntPtr vessel, int flightmodel, Interfaces::Vessel2^ vessel2)
		{
			return (IntPtr)(new Vessel2((OBJHANDLE)vessel, flightmodel, vessel2));
		}
		void Vessel::Exit(IntPtr vessel)
		{			
			if (vessel!=IntPtr::Zero) delete (Vessel2 *)(VESSEL2 *)(VESSEL *)(void *)vessel;
		}
	}
}

