using System;

namespace Orbiter.Interfaces
{
    public class Vector3
    {
        private double m_X;
        private double m_Y;
        private double m_Z;

        public double Z
        {
            get { return m_Z; }
            set { m_Z = value; }
        }

        public double Y
        {
            get { return m_Y; }
            set { m_Y = value; }
        }

        public double X
        {
            get { return m_X; }
            set { m_X = value; }
        }

        public Vector3(double x, double y, double z)
        {
            m_X = x;
            m_Y = y;
            m_Z = z;
        }

        public static Vector3 operator +(Vector3 a, Vector3 b)
        {
            return new Vector3(a.X + b.X, a.Y + b.Y, a.Z + b.Z);
        }

        public static Vector3 operator -(Vector3 a, Vector3 b)
        {
            return new Vector3(a.X - b.X, a.Y - b.Y, a.Z - b.Z);
        }

        public static Vector3 operator *(Vector3 a, double f)
        {
            return new Vector3(a.X * f, a.Y * f, a.Z * f);
        }

        public static Vector3 operator /(Vector3 a, double f)
        {
            return new Vector3(a.X / f, a.Y / f, a.Z / f);
        }

        public static Vector3 operator -(Vector3 a)
        {
            return new Vector3(-a.X, -a.Y, -a.Z);
        }

        public static Vector3 operator *(Vector3 a, Vector3 b)
        {
            return new Vector3(a.Y * b.Z - b.Y * a.Z, a.Z * b.X - b.Z * a.X, a.X * b.Y - b.X * a.Y);
        }

        public double Length
        {
            get
            {
                return Math.Sqrt(X * X + Y * Y + Z * Z);
            }
        }

        public static double operator &(Vector3 a, Vector3 b)
        {
            return a.X * b.X + a.Y * b.Y + a.Z * b.Z;
        }
    }
}
