<?php

$url    = 'svn://svn.orbiter-forum.com/orbiter';
$file   = '/Orbitersdk/lib/orbiter.lib';
$outDir = '.\\libs'; // "windows style" path!
$over   = '..\\Release\\over.exe';
$specials = array( // revision->name lookup-table for "special" revisions
   1 => 'BETA 3',
  62 => '2016',
  61 => '2016-RC.4',
  60 => '2016-RC.3',
  59 => '2016-RC.2',
  58 => '2016-RC.1'
);

// --- Get available revisions
$revs = array();
$lines = explode("\n", shell_exec('svn log '.$url.$file));
$lines = array_filter($lines, function ($line) {
  global $revs;
  $regExp = '/^r([0-9]+)/';
  $found = preg_match($regExp, $line, $result);
  if ($found) {
    $revs[] = $result[1]-0;
  }
  return $found;
});

sort($revs);

// --- Get missing libs
foreach ($revs as $rev) {
  $outfile = 'orbiter-'.$rev.'.lib';
  $outPath = $outDir.'\\'.$outfile;

  if (file_exists($outPath)) {
    continue;
  }
  echo 'Getting revision '.$rev.' from repository...';
  shell_exec('svn cat '.$url.$file.'@'.$rev.' > '.$outDir.'\\'.$outfile );
  echo 'done!' . PHP_EOL;
}


// --- Run tests
foreach ($revs as $rev) {
  $libfile = 'orbiter-'.$rev.'.lib';
  $libPath = $outDir.'\\'.$libfile;

  $expected = isset($specials[$rev]) ? $specials[$rev] : 'BETA r'.$rev;
  $result   = shell_exec($over.' /N '.$libPath.' 2>nul');

  echo str_pad($libfile,15).': '
     . str_pad($result, 10).' '
     . (($result == $expected) ? 'OK' : 'FAIL') . PHP_EOL;
}