/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.systems;

import static jp.sf.orangesignal.ta.TechnicalAnalysis.ma;
import jp.sf.orangesignal.ta.FourPrice;
import jp.sf.orangesignal.ta.MovingAverage;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * 価格と短期移動平均、中期移動平均、長期移動平均の交差をシグナルとするストラテジーの基底クラスを提供します。
 */
public abstract class MovingAverage3LineCross extends TradingStrategySupport {

	/**
	 * 価格の種類を保持します。
	 */
	private FourPrice price = FourPrice.CLOSE;

	/**
	 * 価格の種類を返します。
	 * 
	 * @return 価格の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 価格の種類を設定します。
	 * 
	 * @param price 価格の種類
	 */
	public void setPrice(FourPrice price) { this.price = price; }

	/**
	 * 短期移動平均の期間を保持します。
	 */
	private int fast = 4;

	/**
	 * 短期移動平均の期間を返します。
	 * 
	 * @return 短期移動平均の期間
	 */
	public int getFast() { return fast; }

	/**
	 * 短期移動平均の期間を設定します。
	 * 
	 * @param fast 短期移動平均の期間
	 */
	public void setFast(int fast) { this.fast = fast; }

	/**
	 * 中期移動平均の期間を保持します。
	 */
	private int mid = 9;

	/**
	 * 中期移動平均の期間を返します。
	 * 
	 * @return 中期移動平均の期間
	 */
	public int getMid() { return mid; }

	/**
	 * 中期移動平均の期間を設定します。
	 * 
	 * @param mid 中期移動平均の期間
	 */
	public void setMid(int mid) { this.mid = mid; }

	/**
	 * 長期移動平均の期間を保持します。
	 */
	private int slow = 18;

	/**
	 * 長期移動平均の期間を返します。
	 * 
	 * @return 長期移動平均の期間
	 */
	public int getSlow() { return slow; }

	/**
	 * 長期移動平均の期間を設定します。
	 * 
	 * @param slow 長期移動平均の期間
	 */
	public void setSlow(int slow) { this.slow = slow; }

	/**
	 * 移動平均の種類を保持します。
	 */
	private MovingAverage type = MovingAverage.SMA;

	/**
	 * 移動平均の種類を返します。
	 * 
	 * @return 移動平均の種類
	 */
	public MovingAverage getType() { return type; }

	/**
	 * 移動平均の種類を設定します。
	 * 
	 * @param type 移動平均の種類
	 */
	public void setType(MovingAverage type) { this.type = type; }

	// ----------------------------------------------------------------------

	/**
	 * 価格データを保持します。
	 */
	protected Number[] prices;

	/**
	 * 短期移動平均データを保持します。
	 */
	protected Number[] ma_fast;

	/**
	 * 中期移動平均データを保持します。
	 */
	protected Number[] ma_mid;

	/**
	 * 長期移動平均データを保持します。
	 */
	protected Number[] ma_slow;

	@Override
	public void prepare() {
		this.prices = getDataset().getTechnicalPrice(this.price);
		this.ma_fast = ma(this.prices, this.fast, this.type);
		this.ma_mid = ma(this.prices, this.mid, this.type);
		this.ma_slow = ma(this.prices, this.slow, this.type);
	}

	@Override
	public void close() {
		this.prices = null;
		this.ma_fast = null;
		this.ma_mid = null;
		this.ma_slow = null;
	}

}
