/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.util;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * {@link ArrayUtils} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class ArrayUtilsTest {

	@Test
	public void testGetMinLength() {
		// Arrange
		final Object[] array1 = new Object[]{ 1, 2, 3 };
		final Object[] array2 = new Object[]{ 4, 5 };
		final Object[] array3 = new Object[]{ 6, 7, 8, 9 };
		// Act + Assert
		assertThat(ArrayUtils.getMinLength(array1, array2, array3), is(array2.length));
	}

	@Test
	public void testGetMaxLength() {
		// Arrange
		final Object[] array1 = new Object[]{ 1, 2, 3 };
		final Object[] array2 = new Object[]{ 4, 5 };
		final Object[] array3 = new Object[]{ 6, 7, 8, 9 };
		final Object[] array4 = new Object[]{ 10 };
		// Act + Assert
		assertThat(ArrayUtils.getMaxLength(array1, array2, array3, array4), is(array3.length));
	}

	@Test
	public void testIsSameLength() {
		// Arrange + Act + Assert
		assertTrue(ArrayUtils.isSameLength(new Object[]{ 1, 2, 3 }, new Object[]{ 4, 5, 6 }));
		// Arrange + Act + Assert
		assertFalse(ArrayUtils.isSameLength(new Object[]{ 1, 2, 3 }, new Object[]{ 4, 5 }));
	}

	@Test
	public void testNotNullIndexOfObjectArray() {
		assertThat(ArrayUtils.notNullIndexOf(new Object[]{ 1, 2, 3 }), is(0));
		assertThat(ArrayUtils.notNullIndexOf(new Object[]{ null, 2, 3 }), is(1));
		assertThat(ArrayUtils.notNullIndexOf(new Object[]{ null, null, 3 }), is(2));
		assertThat(ArrayUtils.notNullIndexOf(new Object[]{ null, null, null }), is(ArrayUtils.INDEX_NOT_FOUND));
	}

	@Test
	public void testNotNullIndexOfObjectArrayInt() {
		assertThat(ArrayUtils.notNullIndexOf(new Object[]{ 1, 2, 3 }, 1), is(1));
		assertThat(ArrayUtils.notNullIndexOf(new Object[]{ null, 2, 3 }, 1), is(1));
		assertThat(ArrayUtils.notNullIndexOf(new Object[]{ null, null, 3 }, 1), is(2));
		assertThat(ArrayUtils.notNullIndexOf(new Object[]{ null, null, null }, 1), is(ArrayUtils.INDEX_NOT_FOUND));
		assertThat(ArrayUtils.notNullIndexOf(new Object[]{ 1, 2, 3 }, 100), is(ArrayUtils.INDEX_NOT_FOUND));
	}

	@Test
	public void testNotNullLastIndexOfObjectArray() {
		assertThat(ArrayUtils.notNullLastIndexOf(new Object[]{ 1, 2, 3 }), is(2));
		assertThat(ArrayUtils.notNullLastIndexOf(new Object[]{ 1, 2, null }), is(1));
		assertThat(ArrayUtils.notNullLastIndexOf(new Object[]{ 1, null, null }), is(0));
		assertThat(ArrayUtils.notNullLastIndexOf(new Object[]{ null, null, null }), is(ArrayUtils.INDEX_NOT_FOUND));
	}

	@Test
	public void testNotNullLastIndexOfObjectArrayInt() {
		assertThat(ArrayUtils.notNullLastIndexOf(new Object[]{ 1, 2, 3 }, 1), is(1));
		assertThat(ArrayUtils.notNullLastIndexOf(new Object[]{ 1, 2, null }, 1), is(1));
		assertThat(ArrayUtils.notNullLastIndexOf(new Object[]{ 1, null, null }, 1), is(0));
		assertThat(ArrayUtils.notNullLastIndexOf(new Object[]{ null, null, null }, 1), is(ArrayUtils.INDEX_NOT_FOUND));
		assertThat(ArrayUtils.notNullLastIndexOf(new Object[]{ 1, 2, 3 }, -1), is(ArrayUtils.INDEX_NOT_FOUND));
	}

	@Test
	public void testExtend() {
		// Act
		assertNull(ArrayUtils.extend(null, 1));

		// Act
		final Number[] r1 = ArrayUtils.extend(new Number[]{ 1, 2, 3 }, 1);
		// Assert
		assertThat(r1.length, is(4));
		assertThat(r1[0].intValue(), is(1));
		assertThat(r1[1].intValue(), is(2));
		assertThat(r1[2].intValue(), is(3));
		assertNull(r1[3]);

		// Act
		final Number[] r2 = ArrayUtils.extend(new Number[]{ 1, 2, 3 }, -1);
		// Assert
		assertThat(r2.length, is(4));
		assertNull(r2[0]);
		assertThat(r2[1].intValue(), is(1));
		assertThat(r2[2].intValue(), is(2));
		assertThat(r2[3].intValue(), is(3));

		// Act
		final Number[] r3 = ArrayUtils.extend(new Number[]{ 1, 2, 3 }, 0);
		// Assert
		assertThat(r3.length, is(3));
		assertThat(r3[0].intValue(), is(1));
		assertThat(r3[1].intValue(), is(2));
		assertThat(r3[2].intValue(), is(3));
	}

	@Test
	public void testIsEmpty() {
		// Act + Assert
		assertTrue(ArrayUtils.isEmpty(null));
		// Act + Assert
		assertTrue(ArrayUtils.isEmpty(new Number[0]));
		// Act + Assert
		assertFalse(ArrayUtils.isEmpty(new Number[]{ 1, 2, 3 }));
	}

	@Test
	public void testIsNotEmpty() {
		// Act + Assert
		assertFalse(ArrayUtils.isNotEmpty(null));
		// Act + Assert
		assertFalse(ArrayUtils.isNotEmpty(new Number[0]));
		// Act + Assert
		assertTrue(ArrayUtils.isNotEmpty(new Number[]{ 1, 2, 3 }));
	}

}
