/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.unit;

import java.util.Collections;

/**
 * 呼び値単位情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class BidAndOfferPriceUnits extends PriceUnits {

	private static final long serialVersionUID = 7636226615301082440L;

	/**
	 * デフォルトコンストラクタです。
	 */
	public BidAndOfferPriceUnits() {
		units.add(new PriceUnit(30000000, 100000));
		units.add(new PriceUnit(20000000,  50000));
		units.add(new PriceUnit( 1000000,  10000));
		units.add(new PriceUnit(  100000,   1000));
		units.add(new PriceUnit(   50000,    100));
		units.add(new PriceUnit(   30000,     50));
		units.add(new PriceUnit(    3000,     10));
		units.add(new PriceUnit(    2000,      5));
		units.add(new PriceUnit(       1,      1));
        Collections.sort(units);
	}

}
