/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.screen;

import java.awt.BorderLayout;

import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ScrollPaneConstants;

import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.event.SideScreenListener;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.canvas.IndexCanvas;
import jp.sf.orangesignal.chart.util.StringManager;

/**
 * 
 * @author 杉澤 浩二
 */
public class TimeSeriesSideScreen extends SideScreen {

	private static final long serialVersionUID = 5540314903340196869L;

	/**
	 * 指標キャンバスを保持します。
	 */
	private final IndexCanvas canvas;

	/**
	 * 分析タブを保持します。
	 */
	private final Analysis analysis = new Analysis();

	/**
	 * その他タブを保持します。
	 */
	private final Option option = new Option();

	/**
	 * コンストラクタです。
	 * 
	 * @param icons アイコン情報
	 */
	public TimeSeriesSideScreen(final Icons icons) {
		// 各コントロールを初期化します。
		this.canvas = new IndexCanvas(icons);

		final JTabbedPane tab = new JTabbedPane(JTabbedPane.BOTTOM, JTabbedPane.SCROLL_TAB_LAYOUT);

		// 指標タブ
		tab.addTab(StringManager.getString("tab.indices"), icons.getOnepoint(), this.canvas);
		// 分析タブ
		final JScrollPane sp = new JScrollPane(this.analysis, ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		sp.setBorder(null);
		tab.addTab(StringManager.getString("tab.analysis"), icons.getOnepoint(), sp);
		// 全体設定
		tab.addTab(StringManager.getString("tab.settings"), icons.getOnepoint(), this.option);

		setLayout(new BorderLayout());
		add(tab, BorderLayout.CENTER);
	}

	@Override
	public final void addSideScreenListener(final SideScreenListener listener) {
		this.analysis.addSideScreenListener(listener);
		this.option.addSideScreenListener(listener);
	}

	/**
	 * この実装は何も行いません。
	 */
	@Override
	public void load(final ChartSettings settings) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override
	public void save(final ChartSettings settings) {}

	@Override
	public void datasetSwitch(final ChartEvent e) {
		this.canvas.switchDataset(e);
		this.analysis.datasetSwitch(e);
		this.option.datasetSwitch(e);
	}

	@Override
	public void periodSwitch(final ChartEvent e) {
		this.canvas.switchDataset(e);
	}

	@Override
	public void settingChanged(final ChartEvent e) {
		this.canvas.switchDataset(e);
	}

	@Override
	public void positionChanged(final ChartScreenEvent e) {
		this.canvas.setup(e);
	}

	@Override
	public void setVisibleAdvancedOptions(final boolean visible) {
		this.analysis.setVisibleAdvancedOptions(visible);
	}

}
