/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.screen;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.ChartSettings.RenkohSettings;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.canvas.IndexCanvas;
import jp.sf.orangesignal.chart.util.StringManager;

/**
 * 練行足(練り足)サイド画面を提供します。
 * 
 * @author 杉澤 浩二
 */
public class RenkohSideScreen extends SideScreen {

	private static final long serialVersionUID = -8996118555313552846L;

	/**
	 * 指標キャンバスを保持します。
	 */
	private final IndexCanvas canvas;

	/**
	 * [範囲に0を含める]チェックボックスを保持します。
	 */
	private final JCheckBox fixed = new JCheckBox(StringManager.getString("fixed"));

	private JSpinner rate = new JSpinner(new SpinnerNumberModel(3, 1, 100, 1));

	/**
	 * コンストラクタです。
	 * 
	 * @param icons アイコン情報
	 */
	public RenkohSideScreen(final Icons icons) {
		// 各コントロールを初期化します。
		this.canvas = new IndexCanvas(icons);

		// レイアウトを処理します。
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		setLayout(layout);

		int y = 0;

		addCanvas(layout, c, y++, this.canvas);
		addCheckBox(layout, c, y++, this.fixed);
		addSeparator(layout, c, y++);
		addPanel(layout, c, y, createParamPanel());
	}

	private JPanel createParamPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("rate")), this.rate);

		return panel;
	}

	@Override
	public void load(final ChartSettings settings) {
		setVisibleAdvancedOptions(settings.advancedOptions);
		final RenkohSettings s = settings.renkoh;
		this.fixed.setSelected(s.fixed);
		this.rate.setValue(s.rate);
	}

	@Override
	public void save(final ChartSettings settings) {
		final RenkohSettings s = settings.renkoh;
		s.fixed = this.fixed.isSelected();
		s.rate = (Integer) this.rate.getValue();
	}

	public boolean isIgnoreStart(final ChartSettings settings) {
		final RenkohSettings s = settings.renkoh;
		return s.fixed != this.fixed.isSelected();
	}

	@Override
	public void datasetSwitch(final ChartEvent e) {
		super.notify = false;
		final boolean enabled = e.getDataset() != null;

		this.fixed.setEnabled(enabled);
		this.rate.setEnabled(enabled);

		if (enabled)
			load(e.getSettings());

		this.canvas.switchDataset(e);
		super.notify = true;
	}

	@Override
	public void periodSwitch(final ChartEvent e) {
		this.canvas.switchDataset(e);
	}

	@Override
	public void settingChanged(final ChartEvent e) {
		this.canvas.switchDataset(e);
	}

	@Override
	public void positionChanged(final ChartScreenEvent e) {
		this.canvas.setup(e);
	}

	@Override
	public void setVisibleAdvancedOptions(final boolean visible) {
		this.fixed.setVisible(visible);
	}

}
