/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.screen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import jp.sf.orangesignal.chart.data.ChartDataset;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.ui.ChartScreenType;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.canvas.StepChartCanvas;
import jp.sf.orangesignal.chart.ui.screen.ChartScreen;

public class StepChartScreen
extends ChartScreen
implements AdjustmentListener {
    private static final long serialVersionUID = -4065158006724751295L;
    private final StepChartCanvas canvas;
    private final JScrollBar scrollbar = new JScrollBar(0, 0, 0, 0, 0);

    public StepChartScreen(Icons icons, ChartScreenType screenType) {
        this.canvas = new StepChartCanvas(icons, this, screenType);
        this.scrollbar.addAdjustmentListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.add((Component)this.scrollbar, "South");
    }

    @Override
    public void datasetSwitch(ChartEvent e) {
        this.processChartEvent(e);
    }

    @Override
    public void periodSwitch(ChartEvent e) {
        this.processChartEvent(e);
    }

    @Override
    public void settingChanged(ChartEvent e) {
        this.processChartEvent(e);
    }

    private void processChartEvent(ChartEvent e) {
        if (!e.isIgnoreStart()) {
            ChartDataset dataset = e.getDataset();
            if (dataset == null) {
                this.scrollbar.setMaximum(0);
                this.scrollbar.setVisibleAmount(0);
                this.scrollbar.setValue(0);
                this.scrollbar.setBlockIncrement(0);
                this.scrollbar.setEnabled(false);
            } else {
                this.scrollbar.setValue(0);
                this.scrollbar.setMaximum(dataset.getCount());
                this.scrollbar.setVisibleAmount(e.getPeriod());
                this.scrollbar.setValue(e.getStart());
                this.scrollbar.setBlockIncrement(e.getPeriod() / 2);
                this.scrollbar.setEnabled(true);
            }
        }
        this.canvas.switchDataset(e);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.canvas.setStart(e.getValue());
    }
}

