/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.data;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.DataConvertUtils;
import jp.sf.orangesignal.ta.data.DatasetBinder;
import jp.sf.orangesignal.ta.data.DatasetPreparationException;
import jp.sf.orangesignal.ta.data.DatasetSource;
import jp.sf.orangesignal.ta.data.DateFormatConfig;
import jp.sf.orangesignal.ta.data.DateTruncater;
import jp.sf.orangesignal.ta.data.MergeGapFillType;
import jp.sf.orangesignal.ta.data.MergeMatchType;
import jp.sf.orangesignal.ta.data.NumberFormatConfig;
import jp.sf.orangesignal.ta.util.Assert;

public class DatasetItems
implements Serializable,
DatasetSource {
    private static final long serialVersionUID = -8136157897132992167L;
    private Map<String, Date[]> dateMap = new HashMap<String, Date[]>();
    private Map<String, Number[]> numberMap = new HashMap<String, Number[]>();
    private Map<String, DateFormatConfig> dateFormatConfigMap = new HashMap<String, DateFormatConfig>();
    private Map<String, NumberFormatConfig> numberFormatConfigMap = new HashMap<String, NumberFormatConfig>();
    private Map<String, CompressType> compressTypeMap = new HashMap<String, CompressType>();

    @Override
    public Map.Entry<String, Date[]> getUniqueDateEntry() throws IllegalStateException {
        Iterator<Map.Entry<String, Date[]>> i$;
        if (this.dateMap.size() == 1 && (i$ = this.dateMap.entrySet().iterator()).hasNext()) {
            Map.Entry<String, Date[]> entry = i$.next();
            return entry;
        }
        throw new IllegalStateException("Non-unique date");
    }

    @Override
    public Date[] getDate(String name) {
        return this.dateMap.get(name);
    }

    @Override
    public Map<String, Date[]> getDateMap() {
        return this.dateMap;
    }

    public void setDate(String name, Date[] date) {
        this.dateMap.put(name, date);
    }

    @Override
    public Map.Entry<String, Number[]> getUniqueNumberEntry() throws IllegalStateException {
        Iterator<Map.Entry<String, Number[]>> i$;
        if (this.numberMap.size() == 1 && (i$ = this.numberMap.entrySet().iterator()).hasNext()) {
            Map.Entry<String, Number[]> entry = i$.next();
            return entry;
        }
        throw new IllegalStateException("Non-unique data");
    }

    @Override
    public Number[] getNumber(String name) {
        return this.numberMap.get(name);
    }

    @Override
    public Map<String, Number[]> getNumberMap() {
        return this.numberMap;
    }

    public void setNumber(String key, Number[] data) {
        this.numberMap.put(key, data);
    }

    @Override
    public DateFormatConfig getDateFormatConfig(String name) {
        return this.dateFormatConfigMap.get(name);
    }

    public void setDateFormatConfig(String name, DateFormatConfig config) {
        this.dateFormatConfigMap.put(name, config);
    }

    @Override
    public NumberFormatConfig getNumberFormatConfig(String name) {
        return this.numberFormatConfigMap.get(name);
    }

    public void setNumberFormatConfig(String name, NumberFormatConfig config) {
        this.numberFormatConfigMap.put(name, config);
    }

    @Override
    public CompressType getCompressType(String key) {
        return this.compressTypeMap.get(key);
    }

    @Override
    public Map<String, CompressType> getCompressTypeMap() {
        return this.compressTypeMap;
    }

    public void setCompressType(String name, CompressType compressType) {
        this.compressTypeMap.put(name, compressType);
    }

    @Override
    public boolean isCompressable() {
        for (Map.Entry<String, CompressType> entry : this.compressTypeMap.entrySet()) {
            if (entry.getValue() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public DatasetSource merge(DatasetSource items, MergeMatchType matchType) {
        return this.merge(items, matchType, null, null);
    }

    @Override
    public DatasetSource merge(DatasetSource items, MergeMatchType matchType, MergeGapFillType fillType, Number fill) {
        Assert.notNull(items, "Items must not be null");
        Assert.isTrue(matchType != MergeMatchType.INSERT, "Unsupported merge match type: " + (Object)((Object)matchType));
        Map.Entry<String, Date[]> baseEntry = this.getUniqueDateEntry();
        Date[] base = baseEntry.getValue();
        Date[] date = items.getUniqueDateEntry().getValue();
        for (Map.Entry<String, Number[]> entry : items.getNumberMap().entrySet()) {
            SortedMap<Date, Number> map = DataConvertUtils.merge(base, date, (Object[])entry.getValue(), matchType, fillType, fill);
            this.numberMap.put(entry.getKey(), map.values().toArray(new Number[0]));
            this.dateMap.put(baseEntry.getKey(), map.keySet().toArray(new Date[0]));
        }
        return this;
    }

    @Override
    public DatasetSource compress(int unit) {
        return this.compress(unit, Calendar.getInstance(), new DateTruncater());
    }

    @Override
    public DatasetSource compress(int unit, Calendar calendar) {
        return this.compress(unit, calendar, new DateTruncater());
    }

    @Override
    public DatasetSource compress(int unit, Calendar calendar, DateTruncater truncater) {
        if (!this.isCompressable()) {
            return this;
        }
        Map.Entry<String, Date[]> dateEntry = this.getUniqueDateEntry();
        Date[] date = dateEntry.getValue();
        for (Map.Entry<String, Number[]> data : this.numberMap.entrySet()) {
            CompressType compressType = this.compressTypeMap.get(data.getKey());
            if (compressType != null) {
                SortedMap<Date, Number> map = DataConvertUtils.compress(date, data.getValue(), compressType, unit, calendar, truncater);
                this.dateMap.put(dateEntry.getKey(), map.keySet().toArray(new Date[0]));
                data.setValue(map.values().toArray(new Number[0]));
                continue;
            }
            data.setValue(null);
        }
        return this;
    }

    @Override
    public <T> DatasetBinder<T> bind(T dataset) {
        return new DatasetBinder<T>(this, dataset);
    }

    @Override
    public <T> DatasetBinder<T> build(Class<T> datasetClass) {
        Assert.notNull(datasetClass, "datasetClass must not be null");
        try {
            return new DatasetBinder<T>(this, datasetClass.newInstance());
        }
        catch (IllegalAccessException e) {
            throw new DatasetPreparationException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new DatasetPreparationException(e.getMessage(), e);
        }
    }
}

