package jp.sf.orangesignal.ta.data.sample;

import java.util.Date;
import java.util.List;

import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.annotation.DateItem;
import jp.sf.orangesignal.ta.data.annotation.NumberCompressorType;
import jp.sf.orangesignal.ta.data.annotation.NumberItem;

public class CollectionDataset {

	@DateItem
	public List<Date> date;

	@NumberItem
	@NumberCompressorType(CompressType.FIRST)
	public List<Number> open;

	@NumberItem
	@NumberCompressorType(CompressType.HIGHEST)
	public List<Number> high;

	@NumberItem
	@NumberCompressorType(CompressType.LOWEST)
	public List<Number> low;

	@NumberItem
	@NumberCompressorType(CompressType.LAST)
	public List<Number> close;

	@NumberItem
	@NumberCompressorType(CompressType.SUM)
	public List<Number> volume;

}
