/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.util;

import java.util.Date;

/**
 * 日時配列操作に関するユーティリティを提供します。
 * 
 * @author 杉澤 浩二
 * @deprecated 削除予定。代わりに {@link java.util.NavigableSet} の {@link java.util.NavigableSet#floor(Object)} や {@link java.util.NavigableSet#lower(Object)} などを使用して下さい。
 */
public abstract class DateArrayUtils {

	/**
	 * <p>指定された日時データから指定された日時以後 (<code>null</code> 可) を含む最初の位置を返します。</p>
	 * 指定された日時データが <code>null</code> の場合は <code>-1</code> を返します。
	 * 
	 * @param array 日時データ
	 * @param find 検索する日時 (<code>null</code> 可)
	 * @return 指定された日時以後を含む最初の位置。見つからない場合は <code>-1</code>
	 */
	public static int indexOf(final Date[] array, final Date find) {
		return indexOf(array, find, 0);
	}

	/**
	 * <p>指定された日時データから指定された日時以後 (<code>null</code> 可) を含む最初の位置を返します。</p>
	 * 指定された日時データが <code>null</code> の場合は <code>-1</code> を返します。
	 * 
	 * @param array 日時データ
	 * @param find 検索する日時 (<code>null</code> 可)
	 * @param start 開始位置
	 * @return 指定された日時以後を含む最初の位置。見つからない場合は <code>-1</code>
	 */
	public static int indexOf(final Date[] array, final Date find, final int start) {
		if (array == null)
			return ArrayUtils.INDEX_NOT_FOUND;

		final int length = array.length;
		final int _start = Math.max(start, 0);
		if (find == null) {
			for (int i = _start; i < length; i++) {
				if (array[i] == null) {
					return i;
				}
			}
		} else {
			for (int i = _start; i < length; i++) {
				if (array[i] != null && find.compareTo(array[i]) <= 0) {
					return i;
				}
			}
		}
		return ArrayUtils.INDEX_NOT_FOUND;
	}

	/**
	 * <p>指定された日時データから指定された日時以前 (<code>null</code> 可) を含む最後の位置を返します。</p>
	 * 指定された日時データが <code>null</code> の場合は <code>-1</code> を返します。
	 * 
	 * @param array 日時データ
	 * @param find 検索する日時 (<code>null</code> 可)
	 * @return 指定された日時以前を含む最後の位置。見つからない場合は <code>-1</code>
	 */
	public static int lastIndexOf(final Date[] array, final Date find) {
		return lastIndexOf(array, find, Integer.MAX_VALUE);
	}

	/**
	 * <p>指定された日時データから指定された日時以前 (<code>null</code> 可) を含む最後の位置を返します。</p>
	 * 指定された日時データが <code>null</code> の場合は <code>-1</code> を返します。
	 * 
	 * @param array 日時データ
	 * @param find 検索する日時 (<code>null</code> 可)
	 * @param start 開始位置
	 * @return 指定された日時以前を含む最後の位置。見つからない場合は <code>-1</code>
	 */
	public static int lastIndexOf(final Date[] array, final Date find, final int start) {
		if (array == null || start < 0)
			return ArrayUtils.INDEX_NOT_FOUND;

		final int length = array.length;
		final int _start = start >= length ? length - 1 : start;
		if (find == null) {
			for (int i = _start; i >= 0; i--) {
				if (array[i] == null)
					return i;
			}
		} else {
			for (int i = _start; i >= 0; i--) {
				if (array[i] != null && find.compareTo(array[i]) >= 0) {
					return i;
				}
			}
		}
		return ArrayUtils.INDEX_NOT_FOUND;
	}

}
