/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

/**
 * データマージ時における日時の突合せ方法を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.1
 */
public enum MergeMatchType {

	/**
	 * 基準日時と一致するもののみ関連付けます。
	 */
	STRICT,

	/**
	 * 基準日時以後で一番小さいものに関連付けます。
	 */
	CURRENT,

	/**
	 * 次の基準日時に関連付けます。
	 */
	NEXT,

	/**
	 * 基準日時と一致する場合、基準日時と一致するものに関連付けます。基準日時と一致しない場合、データから新たに関連付けを作成します。
	 */
	INSERT;

}
