/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta;

/**
 * <p>移動平均の種類を表す列挙型を提供します。</p>
 * この列挙型では単一データでの移動平均のみ提供します。
 * 
 * @author 杉澤 浩二
 */
public enum MovingAverage {

	/**
	 * 単純移動平均 (Simple Moving Average)
	 */
	SMA,

	/**
	 * 平滑移動平均 (Smoothed Moving Average)
	 */
	SMMA,

	/**
	 * 幾何学移動平均 (Geometric Moving Average)
	 */
	GMA,

	/**
	 * 修正移動平均 (Running Moving Average)
	 */
	RMA,

	/**
	 * ワイルダー移動平均 (Welles Wilder's Moving Average)
	 */
	WWMA,

	/**
	 * 加重移動平均 (Weighted Moving Average)
	 */
	WMA,

	/**
	 * ハル移動平均 (Hull's Moving Average)
	 */
	HMA,

	/**
	 * 三角移動平均 (Triangular Moving Average)
	 */
	TMA,

	/**
	 * 指数平滑移動平均 (Exponential Moving Average)
	 */
	EMA,

	/**
	 * 二重指数平滑移動平均 (Double Exponential Moving Average)
	 */
	DEMA,

	/**
	 * 三重指数平滑移動平均 (Triple Exponential Moving Average)
	 */
	TEMA,

	/**
	 * 零ラグ指数平滑移動平均 (Zero Lag Exponential Moving Average)
	 */
	ZLEMA,

	/**
	 * エンドポイント移動平均 (Endpoint Moving Average)
	 */
	EPMA,

	/**
	 * ティルソン T3 移動平均 (Tillson's T3 Moving Average)
	 */
	T3;

}
